/*****************************************************************************
*
* FILE NAME:		IoSmpl.c
*
* DESCRIPTION:		RT-edge I/O sample service for INtime
*					I/Oo̓T[rXz肵TvT[rX񋟂܂
*
*
\*****************************************************************************/

#include <stdio.h>
#include <math.h>
#include "edgeCode.h"		// RT-edge T[rXʒ`/֐wb_ǉ

//////////////////////////////////////////////////////////////////////////////
/// e{֐`Jn
///
/// <summary>
/// T[rXCWP[^/T[rXvpeB^O/T[rXŗL^O
/// </summary>
/// <summary>
/// T[rXCWP[^
/// </summary>
char IND_MYSERV_STATUS[EG_MAX_TAGNAME + 1] = { 0 };			// T[rXN
char IND_MYSERV_ERROR[EG_MAX_TAGNAME + 1] = { 0 };			// T[rXG[
char IND_MYSERV_RUN[EG_MAX_TAGNAME + 1] = { 0 };			// T[rXs
char IND_MYSERV_LIVE[EG_MAX_TAGNAME + 1] = { 0 };			// T[rXsJE^
/// <summary>
/// T[rXvpeB^O
/// </summary>
/// </summary>
char PROP_MYSERV_MODE[EG_MAX_TAGNAME + 1] = { 0 };			// 샂[h
char PROP_MYSERV_CYCLE[EG_MAX_TAGNAME + 1] = { 0 };			// T[rXTCN(ms)
char PROP_MYSERV_INPRIO[EG_MAX_TAGNAME + 1] = { 0 };		// EdgeVXeւ̓̓T[rXXbhvCIeB
char PROP_MYSERV_OUTPRIO[EG_MAX_TAGNAME + 1] = { 0 };		// EdgeVXȅo̓T[rXXbhvCIeB

/*****************************************************************************
* FUNCTION:			fnTagNameCreate
* DESCRIPTION:		^O𐶐
\*****************************************************************************/
void fnServiceTagNameCreate()
{
	/// T[rXCWP[^
	sprintf(IND_MYSERV_STATUS, "SERVICE.%s.Status", ServiceRealName);				// T[rXN
	sprintf(IND_MYSERV_ERROR, "SERVICE.%s.Error", ServiceRealName);					// T[rXG[
	sprintf(IND_MYSERV_RUN, "SERVICE.%s.Run", ServiceRealName);						// T[rXs
	sprintf(IND_MYSERV_LIVE, "SERVICE.%s.Live", ServiceRealName);					// T[rXsJE^

	/// T[rXvpeB^O
	sprintf(PROP_MYSERV_MODE, "SERVICE.%s.Mode", ServiceRealName);					// 샂[h
	sprintf(PROP_MYSERV_CYCLE, "SERVICE.%s.Cycle", ServiceRealName);				// T[rXTCN(ms)
	sprintf(PROP_MYSERV_INPRIO, "SERVICE.%s.InPriorityode", ServiceRealName);		// EdgeVXeւ̓̓T[rXXbhvCIeB
	sprintf(PROP_MYSERV_OUTPRIO, "SERVICE.%s.OutPriority", ServiceRealName);		// EdgeVXȅo̓T[rXXbhvCIeB
}
/// <summary>
/// EdgebZ[Wnh
/// [TODO] : KvɉăbZ[WEǉ
/// </summary>
/// <param name="sender">bZ[WM</param>
/// <param name="msgno">bZ[Wԍ</param>
/// <param name="param">bZ[Wp[^</param>
/// <returns>펞O</returns>
int32_t MsgHandler(const char* sender, int32_t msgno, void *param)
{
	int32_t	result = 0;

	switch (msgno)
	{
	case EM_SERVICE_RUN:			// T[rXJnw
		result = StartService(&MyState);
		break;
	case EM_SERVICE_STOP:			// T[rXIw
		result = KillService(&MyState);
		break;
	case EM_SERVICE_PAUSE:			// T[rXꎞ~w
		result = PauseService(&MyState);
		break;
	case EM_SERVICE_UPDATE:			// T[rXAbvf[gw
		switch (MyState.Mode)
		{
		case MODE_AUTO:				// TCN[hiTCNXbĥŖj
			break;
		case MODE_SEMIAUTO:			// TCN[hio͂̍XVsj
			KickOutput(&MyState);
			break;
		case MODE_MANUAL:			// 蓮TCN[hio͋ɍXVsj
			KickInput(&MyState);
			KickOutput(&MyState);
			break;
		}
		break;
	//
	// [TODO] : Cӂ̃bZ[Wǉ
	//
	case EM_SERVICE_IO_MODE_1:
		MyState.SmplIoMode = 1;
		break;
	case EM_SERVICE_IO_MODE_2:
		MyState.SmplIoMode = 2;
		break;
	case EM_SERVICE_IO_MODE_3:
		MyState.SmplIoMode = 3;
		break;
	default:						//LȊO͔
		break;
	}
	return result;
}
/// <summary>
/// EdgeVXeo͎TCNXbh
/// KvΕύXsv
/// </summary>
/// <param name="state"></param>
void ThreadAutoCycle(struct MYSTATE *state)
{
	RtSleepEx(1);						// ̃gK^C~OJ[leBbNɂ낦

	while (1)
	{
		++state->Live;					// T[rXsJE^
		GetProperty(state);				// T[rXvpeB̃[h

		if (state->Run)					// T[rXsԂȂ珈
		{
			switch (state->Mode)		// T[rX샂[hɉĕ
			{
			case MODE_AUTO:				// TCN[hio͋ɎXVj
				KickInput(state);
				KickOutput(state);
				break;
			case MODE_SEMIAUTO:			// TCNi͂̂ݎXVAo͂EM_SERVICE_UPDATEŎw߁j
				KickInput(state);
				break;
			case MODE_MANUAL:			// 蓮TCNio͂EM_SERVICE_UPDATEŎw߂̂Ŗj
				break;
			}
		}

		UpdateIndicator(state);			// T[rXCWP[^XV
		RtSleepEx(state->Cycle);		// TCN҂
	}
}
/// <summary>
/// EdgeVXeւ̃f[^
/// [TODO] : KvɉĒlރ^Oƒlw
/// </summary>
/// <param name="state"></param>
void ThreadInService(struct MYSTATE *state)
{
	int32_t				result = 0;
	float				valBase = 0;
	int32_t				val1 = 0;
	double				val2 = 0;
	float				val3 = 0;
	int32_t				calcV = 1;
	bool				bIsAddF = true;

	//`FbN
	if (egTagRefs_IN_Count == 0)
	{
		EgFW_PrintLog(ServiceRealName, EG_LOG_ERR, "ReadIOThread No Data");	// G[Oo(t[[N)
		printf("[ERROR] : ReadIOThread No Data");
		return;
	}

	while (1)
	{
		WaitForRtSemaphore(state->hInTrigSem, 1, WAIT_FOREVER);			// ̓^C~OgK҂
		//
		//EgTag֒l݂
		//
		
		//
		// Signgo͂邽߂̏
		//

		switch (state->SmplIoMode)
		{
		case 1:
			calcV = 1;
			break;
		case 2:
			calcV = 2;
			break;
		case 3:
			calcV = 3;
			break;
		default:
			calcV = 1;
			break;
		}
		val1 = (int32_t)(calcV * sin((double)(valBase * M_PI / 180.0)));
		val2 = 2 * calcV * sin((double)(valBase * M_PI / 180.0));
		val3 = (float)(3 * calcV * sin((double)(valBase * M_PI / 180.0)));

		valBase = valBase++;
		if (valBase == 360)
			valBase = 0;
		//
		// EgTagWrite
		//

		result |= EgTagWrite(egTagRefs_IN[0].Name, &val1, sizeof(val1));			// Cӂ̒l
		result |= EgTagWrite(egTagRefs_IN[1].Name, &val2, sizeof(val2));			// Cӂ̒l
		result |= EgTagWrite(egTagRefs_IN[2].Name, &val3, sizeof(val3));			// Cӂ̒l

		state->Error = (result != EDGE_SUCCESS);	// G[CWP[^XV
	}
}
/// <summary>
/// EdgeVXẽf[^o
/// [TODO] : KvɉĒlǂݍރ^Ow
/// </summary>
/// <param name="state"></param>
void ThreadOutService(struct MYSTATE *state)
{
	while (1)
	{
		WaitForRtSemaphore(state->hOutTrigSem, 1, WAIT_FOREVER);		// o̓^C~OgK҂
		//
		//[TODO] : KvɉĔCӂEgTaglǍ
		//
		//) Ԃ擾
		// ȉŎ ts EDGE_TIME_STAMP̃CX^X 
		//result |= EgTagRead(TAG_MYSERV_XXXX1, &ts.time, sizeof(ts.time));			// Cӂ̒l
		//result |= EgTagRead(TAG_MYSERV_XXXX2, &ts.millisecond, , sizeof(ts.millisecond));	// VXei[(ms)
	}
}
/// <summary>
/// ̓T[rX1LbN
/// KvΕύXsv
/// </summary>
/// <param name="state"></param>
void KickInput(struct MYSTATE *state)
{
	ReleaseRtSemaphore(state->hInTrigSem, 1);
}

/// <summary>
/// o̓T[rX1LbN
/// KvΕύXsv
/// </summary>
/// <param name="state"></param>
void KickOutput(struct MYSTATE *state)
{
	ReleaseRtSemaphore(state->hOutTrigSem, 1);
}
/// <summary>
/// T[rX^O łɐĂꍇ͖Čp܂
/// [TODO] : Kvɉč쐬^Ow(^O̐XMLɒ`邱Ƃ𐄏)
/// </summary>
/// <param name="state"></param>
/// <returns>펞O</returns>
int32_t CreateServiceTags(struct MYSTATE *state)
{
	int32_t		result = 0;

	// T[rX^Oނ̐
	// [TODO] : KvɉĈȉR[hC
	//result |= EgTagCreateEx(TAG_MYSERV_XXX, EgVtUInt64, "", "sample tag");

	return EDGE_SUCCESS;
}
/// <summary>
/// T[rXCWP[^̍XV XVɎsĂČp܂
/// KvΕύXsv
/// </summary>
/// <param name="state"></param>
/// <returns>펞O</returns>
int32_t UpdateIndicator(struct MYSTATE *state)
{
	// CWP[^^O̓t[[NɂĎ
	int32_t		result = 0;
	result |= EgTagWrite(IND_MYSERV_STATUS, &state->State, 1);		// T[rXN
	result |= EgTagWrite(IND_MYSERV_RUN, &state->Run, 1);			// T[rXs
	result |= EgTagWrite(IND_MYSERV_LIVE, &state->Live, 4);			// T[rXsJE^
	result |= EgTagWrite(IND_MYSERV_ERROR, &state->Error, 1);		// T[rXُ
	return result;
}
/// <summary>
/// T[rXvpeB̎擾 擾łȂ̓ftHgݒl̗p܂
/// [TODO] : KvɉĐݒ荀ڂ̑w
/// </summary>
/// <param name="state"></param>
/// <returns>펞O</returns>
int32_t GetProperty(struct MYSTATE *state)
{
	// vpeB^OXML`\@Ƃ̓ftHgݒl̗p܂
	int32_t		result;
	result = EgTagRead(PROP_MYSERV_MODE, &state->Mode, 1);				// T[rX샂[h̎擾
	if (result != EDGE_SUCCESS)	state->Mode = DEFAULT_MODE;				// ftHg

	result = EgTagRead(PROP_MYSERV_CYCLE, &state->Cycle, 4);			// T[rXTCN̎擾
	if (result != EDGE_SUCCESS)	state->Cycle = DEFAULT_CYCLE;			// ftHg

	result = EgTagRead(PROP_MYSERV_INPRIO, &state->InPriority, 1);		// ̓T[rXXbh̃vCIeBw
	if (result != EDGE_SUCCESS)	state->InPriority = DEFAULT_INPRIO;		// ftHg

	result = EgTagRead(PROP_MYSERV_OUTPRIO, &state->OutPriority, 1);	// o̓T[rXXbh̃vCIeBw
	if (result != EDGE_SUCCESS)	state->OutPriority = DEFAULT_OUTPRIO;	// ftHg

	//
	// [TODO] : Cӂ̃T[rXvpeBw
	//
	return EDGE_SUCCESS;
}
/// <summary>
/// T[rXJn o͉\ɂȂ܂
/// KvΕύXsv
/// </summary>
/// <returns>펞O</returns>
int32_t StartService(struct MYSTATE *state)
{
	state->Run = true;				// T[rXs
	UpdateIndicator(state);			// T[rXCWP[^XV
	return 0;
}
/// <summary>
/// T[rXꎞ~ o͂ȂȂ܂
/// KvΕύXsv
/// </summary>
/// <returns>펞O</returns>
int32_t PauseService(struct MYSTATE *state)
{
	state->Run = false;				// T[rXꎞ~
	UpdateIndicator(state);			// T[rXCWP[^XV
	return 0;
}
/// <summary>
/// T[rX̏
/// </summary>
/// <returns>펞O</returns>
int32_t InitService(struct MYSTATE *state)
{
	int32_t		result;
	EDGECONFIG	config = EDGE_CONFIG_DEFAULT;
	RTHANDLE	hThread;

	printf("[LOG] : Start "SERVICENAME" Service\n");
	config.fpUserMessHdlFunc = MsgHandler;						// EdgebZ[W[Unh̎w

	result = EgInit(&config);									// Edget[[N̏
	if (result != EDGE_SUCCESS)
		WARN(result);

	fnServiceTagNameCreate();									// T[rXReit^O𐶐

	result = GetProperty(state);								// T[rXvpeB̃[h
	if (result != EDGE_SUCCESS)
		WARN(result);

	result = CreateServiceTags(state);							// T[rXCWP[^̐
	if (result != EDGE_SUCCESS)
		WARN(result);

	state->hInTrigSem = CreateRtSemaphore(0, 10, FIFO_QUEUING);	// ̓T[rXXbhpgKZ}tH
	state->hOutTrigSem = CreateRtSemaphore(0, 10, FIFO_QUEUING);// o̓T[rXXbhpgKZ}tH

	state->SmplIoMode = 0;										// Tvg`o̓[h l0ݒ 

	SetRtProcessMaxPriority(0, 0);														// vZXŏʃvCIeB

	hThread = CreateRtThread(state->OutPriority, ThreadOutService, 0x2000, state);		// o̓T[rXXbh̐
	CatalogRtHandle(0, hThread, "OutServ");

	hThread = CreateRtThread(state->InPriority, ThreadInService, 0x2000, state);		// ̓T[rXXbh̐
	CatalogRtHandle(0, hThread, "InServ");

	uint8_t trigprio = (state->OutPriority < state->InPriority) ? state->OutPriority : state->InPriority;	// ق̃vCIeB擾
	hThread = CreateRtThread(trigprio, ThreadAutoCycle, 0x2000, state);					// T[rXTCNXbh̐
	CatalogRtHandle(0, hThread, "AutoCycle");

	RTHANDLE hRoot = GetRtThreadHandles(ROOT_PROCESS);			// vZXJ^O
	RTHANDLE hThisProc = GetRtThreadHandles(THIS_PROCESS);
	UncatalogRtHandle(hRoot, SERVICENAME);
	CatalogRtHandle(hRoot, hThisProc, SERVICENAME);
	SetLastRtError(0);

	state->State = SERVICE_UP;									// T[rXAbv
	UpdateIndicator(state);										// T[rXCWP[^̍XV

	return result;
}

/// <summary>
/// T[rX폜ivZX~j
/// </summary>
/// <returns>̊֐߂邱Ƃ͂܂</returns>
int32_t KillService(struct MYSTATE *state)
{
	PauseService(state);				// T[rXꎞ~

	state->State = SERVICE_DOWN;		// T[rX_E
	UpdateIndicator(state);				// T[rXCWP[^XV

	TerminateRtProcess(0, 1, 1000);		// vZXɏIv
										// łEgFinalizełȂB߂ĂȂȂ܂B
	printf("[LOG] : End "SERVICENAME" Service\n");
	return 0;
}
/// <summary>
/// [jObZ[W
/// </summary>
/// <param name="position">蔭 __LINE__w</param>
/// <param name="reason">sRR[h</param>
void WarningMsg(int32_t position, int32_t reason)
{
	printf(SERVICENAME" service warning at line(%d) ,reason 0x%08x\n", position, reason);
}