/*****************************************************************************
*
* FILE NAME:		IoSmpl.c
*
* DESCRIPTION:		RT-edge I/O sample service for INtime
*					I/Oo̓T[rXz肵TvT[rX񋟂܂
*					
*
\*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "edgeCode.h"		// RT-edge T[rXʒ`/֐wb_ǉ

/*****************************************************************************
*
* FUNCTION:			main
*
* DESCRIPTION:		C
*
*
\*****************************************************************************/
int			main(int argc, char* argv[])
{
	EVENTINFO		ei;						// INtimeVXeCxg̏̈ג`

	memset(&MyState, 0, sizeof(MyState));	// Xe[^Xp\̏
	InitService(&MyState);					// T[rX̏ ֐Ăяo

	SynchronizeRtLoader();					// T[rX̒ʒm ֐Ăяo

	while (1)								// Cxgҋ@
	{
		RtNotifyEvent(ALL_NOTIFICATIONS, WAIT_FOREVER, &ei);	// INtimeVXeCxg̏
		switch (ei.dwNotifyType)
		{
		case TERMINATE:						// Intex̍폜w
			KillService(&MyState);			// T[rX폜ivZX~j
			EgFinalize();					// EdgeVXe(K{ Edget[[N㏈)
			exit(0);						// T[rXvZX폜
			break;
		case KERNEL_SHUTDOWN_PENDING:		// INtimeJ[l̒~w
			KillService(&MyState);			// T[rX폜ivZX~j
			EgFinalize();					// EdgeVXe(K{ Edget[[N㏈)
			exit(0);						// T[rXvZX폜
			break;
		case NT_BLUESCREEN:					// WindowsNbV
			break;
		}
	}
	return 0;
}

