﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using RTedge;   // RT-edge system API
using EdgeCode; // RT-edge template code
using System.Windows.Forms.Integration;
using System.Windows.Forms.DataVisualization.Charting;
using System.Windows.Threading;
using System.Collections.Concurrent;
using DispSmplCommon;
using System.Collections.ObjectModel;

namespace DispSmpl
{
    /// <summary>
    /// MainWindow.xaml の相互作用ロジック
    /// </summary>
    public partial class MainWindow : Window
    {
        private static uint EM_SERVICE_IO_MODE_1 = EGDEFINE.EG_MSG_USER + 0;    // IoSmpl IO出力モード 1 設定用コマンド
        private static uint EM_SERVICE_IO_MODE_2 = EGDEFINE.EG_MSG_USER + 1;    // IoSmpl IO出力モード 2 設定用コマンド
        private static uint EM_SERVICE_IO_MODE_3 = EGDEFINE.EG_MSG_USER + 2;    // IoSmpl IO出力モード 3 設定用コマンド

        /// <summary>
        /// 描画用定義
        /// </summary>
        private uint MAX_HISTORY = 200;                                         // 表示数
        private int Y_Maximum = 10;                                             // Y軸メモリ最大値
        private int Y_Minimum = -10;                                            // Y軸メモリ最小値
        Queue<double> countHistory1_1 = new Queue<double>();                    // グラフ上段1波形履歴
        Queue<double> countHistory1_2 = new Queue<double>();                    // グラフ上段2波形履歴
        Queue<double> countHistory1_3 = new Queue<double>();                    // グラフ上段3波形履歴
        Queue<double> countHistory2_1 = new Queue<double>();                    // グラフ下段1波形履歴
        Queue<double> countHistory2_2 = new Queue<double>();                    // グラフ下段2波形履歴
        Queue<double> countHistory2_3 = new Queue<double>();                    // グラフ下段3波形履歴
        Chart chart1 = null;
        Series seriesChart1Sign1 = null;                                        // Chart1 Sign1表示用
        Series seriesChart1Sign2 = null;                                        // Chart1 Sign2表示用
        Series seriesChart1Sign3 = null;                                        // Chart1 Sign3表示用

        Chart chart2 = null;
        Series seriesChart2Sign1 = null;                                        // Chart2 Sign1表示用
        Series seriesChart2Sign2 = null;                                        // Chart2 Sign2表示用
        Series seriesChart2Sign3 = null;                                        // Chart2 Sign3表示用

        /// <summary>
        /// コンボボックスの定義
        /// </summary>
        private ObservableCollection<CCmbItem> mCmbTagList;                     //コンボボックスアイテムリスト
        // タイマのインスタンス
        private DispatcherTimer DrawTimer;

        edgeCode EgProc = null;                 //RTedge フレームワーク+APIを使用したコードクラス
        public MainWindow()
        {
            InitializeComponent();              //Componentの初期化(自動生成コード)
            AllocConsole();                     //[DEBUG用] コンソール出力用
            EgProc = new edgeCode();            //RTedge処理クラスの作成
            EgProc.mInstMainClose = Stop;       //フレームワーク内終了メッセージ処理時の関数指定
            EgProc.InitService();               //RTedge処理クラスの初期化

            //以下独自処理
            fnSetCmbItem();                     //タグ情報コンボボックス作成
            DrawTimer = new DispatcherTimer();
            DrawTimer.Interval = new TimeSpan(0, 0, 0, 0, 100);
            DrawTimer.Tick += new EventHandler(DrawTimerMethod);
            InitChart1();                       //グラフ１上段の初期化
            InitChart2();                       //グラフ１上段の初期化
            WEb_set();

        }

        private void WEb_set()
        {
            btn_web.IsEnabled = false;
            //APIの戻り値の変数
            int ians = 0;
            //APIの結果取得変数
            object value = new object();
            //APIでValue値を読み込む
            ians = EgProc.EGAPI.EgTagRead("SERVICE.IoSmpl.Run", ref value);
            if (ians == 0)
            {
                btn_web.IsEnabled = true;

                if (value.ToString() == "True")
                {
                    lbl_web.Content = "WEBアクセス許可中";
                    btn_web.Content = "禁止へ変更";
                }
                else
                {
                    lbl_web.Content = "WEBアクセス禁止中";
                    btn_web.Content = "許可へ変更";
                }
            }
            else
            {
            }

        }


        /// <summary>
        /// サービス終了処理
        /// </summary>
        public void Stop()
        {
            try
            {
                Dispatcher.Invoke((Action)(() =>
                {
                    Close();                        //Window Close関数呼び出し
                }));
            }
            catch (Exception ex)
            {
                EgProc.LOG(System.Reflection.MethodBase.GetCurrentMethod().Name + " : " + ex.Message);
            }
            ;
        }

        /// <summary>
        /// Windowクローズ処理
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Window_Closing(object sender, System.ComponentModel.CancelEventArgs e)
        {
            try
            {
                EgProc.KillService();           //サービス削除関数呼び出し<必須>
                EgProc.EGAPI.EgFinalize();      //APIのFinalize処理追加 <必須>
                EgProc.Release();               //後処理
                //[TODO] : 必要に応じて終了処理追加
            }
            catch (Exception ex)
            {
                EgProc.LOG(System.Reflection.MethodBase.GetCurrentMethod().Name + " : " + ex.Message);
            }
        }

        /// <summary>
        /// コンボボックス一覧をセット
        /// DSPによってサポートするデータタイプが違う
        /// </summary>
        private void fnSetCmbItem()
        {
            try
            {
                mCmbTagList = new ObservableCollection<CCmbItem>();                 //リスト作成
                for (int i = 0; i < EgProc.EGAPI.EGFW.tagRef_OUT_List.Count; i++)   //定義数分作成
                {
                    mCmbTagList.Add(new CCmbItem() { TagName = EgProc.EGAPI.EGFW.tagRef_OUT_List[i].Name});
                }
                cmbTags.ItemsSource = mCmbTagList;                                  //コンボボックスに設定
                if(EgProc.EGAPI.EGFW.tagRef_OUT_List.Count > 0)
                    cmbTags.SelectedIndex = 0;                                      //初期値設定

            }
            catch (Exception ex)
            {
                EgProc.LOG(System.Reflection.MethodBase.GetCurrentMethod().Name + " : " + ex.Message);
            }
        }
        // タイマメソッド
        private void DrawTimerMethod(object sender, EventArgs e)
        {
            try
            {
                GraphData GraphOneData;
                int iRefreshCount = 0;
                //連続で飛んできた場合mIpcDatasにデータがどんどんたまる それをどんどん処理する
                while (EgProc.EgClctCollection.Count > 0)
                {
                    if (EgProc.EgClctCollection.TryTake(out GraphOneData, System.Threading.Timeout.Infinite) == true)
                    {
                        iRefreshCount++;
                        AddPoint1(GraphOneData.data1, GraphOneData.data2, GraphOneData.data3);
                    }
                }
                RefreshChart1();
                iRefreshCount = 0;
                //連続で飛んできた場合mIpcDatasにデータがどんどんたまる それをどんどん処理する
                while (EgProc.MyClctCollection.Count > 0)
                {
                    if (EgProc.MyClctCollection.TryTake(out GraphOneData, System.Threading.Timeout.Infinite) == true)
                    {
                        iRefreshCount++;
                        AddPoint2(GraphOneData.data1, GraphOneData.data2, GraphOneData.data3);
                    }
                }
                RefreshChart2();
            }
            catch (Exception ex)
            {
                EgProc.LOG(System.Reflection.MethodBase.GetCurrentMethod().Name + " : " + ex.Message);
            }
        }
        /// <summary>
        /// グラフ①の初期化関数
        /// </summary>
        public void InitChart1()
        {
            InitChart1(Y_Maximum, Y_Minimum, MAX_HISTORY);
        }
        /// <summary>
        /// グラフ①の初期化関数
        /// </summary>
        private void InitChart1(int inYMax, int inYMin, uint uiMax)
        {
            try
            {
                var windowsFormsHost = (WindowsFormsHost)grid_chart1.Children[0];
                chart1 = (Chart)windowsFormsHost.Child;

                // チャート全体の背景色を設定
                chart1.BackColor = System.Drawing.Color.Black;                          // 背景を黒へ
                chart1.ChartAreas.Add("ChartArea1");                                    // ChartArea追加
                chart1.ChartAreas[0].BackColor = System.Drawing.Color.Transparent;      // chartエリアを透明へ

                // タイトルの編集
                chart1.Titles.Add("chart_sign1");
                chart1.Titles[0].Text = "Edge コレクタ で取得した値のグラフ";
                chart1.Titles[0].Alignment = System.Drawing.ContentAlignment.TopCenter;//上部中央に表示
                chart1.Titles[0].ForeColor = System.Drawing.Color.White;
                chart1.Titles[0].Font = new System.Drawing.Font("ＭＳ 明朝", 11, System.Drawing.FontStyle.Bold | System.Drawing.FontStyle.Underline);
                
                // チャート表示エリア周囲の余白をカットする
                chart1.ChartAreas[0].InnerPlotPosition.Auto = false;
                chart1.ChartAreas[0].InnerPlotPosition.Width = 100;      // chartの幅   100%
                chart1.ChartAreas[0].InnerPlotPosition.Height = 90;      // chartの高さ 90%(横軸のメモリラベル印字分の余裕を設ける)
                chart1.ChartAreas[0].InnerPlotPosition.X = 8;            // chartエリア内でのchartの開始位置(%)
                chart1.ChartAreas[0].InnerPlotPosition.Y = 0;            // chartエリア内でのchartの開始位置(%)
                chart1.ChartAreas[0].AxisY.Title = "V";
                chart1.ChartAreas[0].AxisY.TextOrientation = TextOrientation.Stacked;


                // X,Y軸情報のセット関数を定義
                // （ラムダ式）
                Action<Axis> setAxis = (Axis axisInfo) =>
                {
                    // 軸のメモリラベルのフォントサイズ上限値を制限
                    axisInfo.LabelAutoFitMaxFontSize = 8;

                    // 軸のメモリラベルの文字色をセット
                    axisInfo.LabelStyle.ForeColor = System.Drawing.Color.White;

                    // 軸タイトルの文字色をセット(今回はTitle未使用なので関係ないが...)
                    axisInfo.TitleForeColor = System.Drawing.Color.White;

                    // 軸の色をセット
                    axisInfo.MajorGrid.Enabled = true;
                    axisInfo.MajorGrid.LineColor = System.Drawing.ColorTranslator.FromHtml("#008242");
                    axisInfo.MinorGrid.Enabled = false;
                    axisInfo.MinorGrid.LineColor = System.Drawing.ColorTranslator.FromHtml("#008242");
                };

                // X,Y軸の表示方法を定義
                setAxis(chart1.ChartAreas[0].AxisY);
                setAxis(chart1.ChartAreas[0].AxisX);
                //（個別の設定）
                chart1.ChartAreas[0].AxisX.MinorGrid.Enabled = true;
                chart1.ChartAreas[0].AxisY.Maximum = Y_Maximum;    // 縦軸の最大値設定
                chart1.ChartAreas[0].AxisY.Minimum = Y_Minimum;    // 縦軸の最小値設定
                chart1.ChartAreas[0].AxisY.MajorTickMark.Interval = 1;

                chart1.AntiAliasing = AntiAliasingStyles.None;

                // Seriesの作成と値の追加
                seriesChart1Sign1 = new Series();
                seriesChart1Sign1.ChartType = SeriesChartType.Line;
                seriesChart1Sign1.BorderWidth = 2;
                chart1.Series.Add(seriesChart1Sign1);
                seriesChart1Sign1.Color = System.Drawing.Color.Transparent;   // 透明
                                                                              // 凡例を非表示,各値に数値を表示しない
                chart1.Series[0].IsVisibleInLegend = false;
                chart1.Series[0].IsValueShownAsLabel = false;

                seriesChart1Sign2 = new Series();
                seriesChart1Sign2.ChartType = SeriesChartType.Line;
                seriesChart1Sign2.BorderWidth = 2;
                chart1.Series.Add(seriesChart1Sign2);
                seriesChart1Sign2.Color = System.Drawing.Color.Transparent;   // 透明

                seriesChart1Sign3 = new Series();
                seriesChart1Sign3.ChartType = SeriesChartType.Line;
                seriesChart1Sign3.BorderWidth = 2;
                chart1.Series.Add(seriesChart1Sign3);
                seriesChart1Sign3.Color = System.Drawing.Color.Transparent;   // 透明

                // 凡例を非表示,各値に数値を表示しない
                chart1.Series[0].IsVisibleInLegend = false;
                chart1.Series[0].IsValueShownAsLabel = false;
                chart1.Series[1].IsVisibleInLegend = false;
                chart1.Series[1].IsValueShownAsLabel = false;
                chart1.Series[2].IsVisibleInLegend = false;
                chart1.Series[2].IsValueShownAsLabel = false;




                // 折れ線グラフとして表示
                chart1.Series[0].ChartType = System.Windows.Forms.DataVisualization.Charting.SeriesChartType.FastLine;
                chart1.Series[1].ChartType = System.Windows.Forms.DataVisualization.Charting.SeriesChartType.FastLine;
                chart1.Series[2].ChartType = System.Windows.Forms.DataVisualization.Charting.SeriesChartType.FastLine;
                // 線の色を指定
                chart1.Series[0].Color = System.Drawing.ColorTranslator.FromHtml("#EF810F");
                chart1.Series[1].Color = System.Drawing.ColorTranslator.FromHtml("#00FF00");
                chart1.Series[2].Color = System.Drawing.ColorTranslator.FromHtml("#0ef0f0");
                // 線の太さを指定
                chart1.Series[0].BorderWidth = 2;
                chart1.Series[1].BorderWidth = 2;
                chart1.Series[2].BorderWidth = 2;


                // 凡例を非表示,各値に数値を表示しない
                chart1.Series[0].IsVisibleInLegend = false;
                chart1.Series[0].IsValueShownAsLabel = false;
                chart1.Series[1].IsVisibleInLegend = false;
                chart1.Series[1].IsValueShownAsLabel = false;
                chart1.Series[2].IsVisibleInLegend = false;
                chart1.Series[2].IsValueShownAsLabel = false;

                // チャートに表示させる値の履歴を全て0クリア
                while (countHistory1_1.Count <= MAX_HISTORY)
                {
                    countHistory1_1.Enqueue(0);
                }
                while (countHistory1_2.Count <= MAX_HISTORY)
                {
                    countHistory1_2.Enqueue(0);
                }
                while (countHistory1_3.Count <= MAX_HISTORY)
                {
                    countHistory1_3.Enqueue(0);
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Fatal Error : " + ex.Message, "fmecui Error", MessageBoxButton.OK);
            }
        }
        
        /// <summary>
        /// グラフ②の初期化
        /// </summary>
        public void InitChart2()
        {
            InitChart2(Y_Maximum, Y_Minimum, MAX_HISTORY);
        }
        /// <summary>
        /// グラフ②の初期化関数
        /// </summary>
        private void InitChart2(int inYMax, int inYMin, uint uiMax)
        {
            try
            {
                var windowsFormsHost = (WindowsFormsHost)grid_chart2.Children[0];
                chart2 = (Chart)windowsFormsHost.Child;
                //グラフ領域全般設定
                chart2.Titles.Add("chart_sign2");
                // チャート全体の背景色を設定
                chart2.BackColor = System.Drawing.Color.Black;                          // 背景を黒へ
                chart2.ChartAreas.Add("ChartArea2");                                    // ChartArea追加
                chart2.ChartAreas[0].BackColor = System.Drawing.Color.Transparent;      // chartエリアを透明へ

                // タイトルの編集
                chart2.Titles[0].Text = "自作 収集処理 で取得した値のグラフ";
                chart2.Titles[0].Alignment = System.Drawing.ContentAlignment.TopCenter;//上部中央に表示
                chart2.Titles[0].ForeColor = System.Drawing.Color.White;
                chart2.Titles[0].Font = new System.Drawing.Font("ＭＳ 明朝", 11, System.Drawing.FontStyle.Bold | System.Drawing.FontStyle.Underline);

                // チャート表示エリア周囲の余白をカットする
                chart2.ChartAreas[0].InnerPlotPosition.Auto = false;
                chart2.ChartAreas[0].InnerPlotPosition.Width = 100;      // chartの幅   100%
                chart2.ChartAreas[0].InnerPlotPosition.Height = 90;      // chartの高さ 90%(横軸のメモリラベル印字分の余裕を設ける)
                chart2.ChartAreas[0].InnerPlotPosition.X = 8;            // chartエリア内でのchartの開始位置(%)
                chart2.ChartAreas[0].InnerPlotPosition.Y = 0;            // chartエリア内でのchartの開始位置(%)
                chart2.ChartAreas[0].AxisY.Title = "V";
                chart2.ChartAreas[0].AxisY.TextOrientation = TextOrientation.Stacked;


                // X,Y軸情報のセット関数を定義
                // （ラムダ式）
                Action<Axis> setAxis = (Axis axisInfo) =>
                {
                    // 軸のメモリラベルのフォントサイズ上限値を制限
                    axisInfo.LabelAutoFitMaxFontSize = 8;

                    // 軸のメモリラベルの文字色をセット
                    axisInfo.LabelStyle.ForeColor = System.Drawing.Color.White;

                    // 軸タイトルの文字色をセット(今回はTitle未使用なので関係ないが...)
                    axisInfo.TitleForeColor = System.Drawing.Color.White;

                    // 軸の色をセット
                    axisInfo.MajorGrid.Enabled = true;
                    axisInfo.MajorGrid.LineColor = System.Drawing.ColorTranslator.FromHtml("#008242");
                    axisInfo.MinorGrid.Enabled = false;
                    axisInfo.MinorGrid.LineColor = System.Drawing.ColorTranslator.FromHtml("#008242");
                };

                // X,Y軸の表示方法を定義
                setAxis(chart2.ChartAreas[0].AxisY);
                setAxis(chart2.ChartAreas[0].AxisX);
                //（個別の設定）
                chart2.ChartAreas[0].AxisX.MinorGrid.Enabled = true;
                chart2.ChartAreas[0].AxisY.Maximum = Y_Maximum;    // 縦軸の最大値設定
                chart2.ChartAreas[0].AxisY.Minimum = Y_Minimum;    // 縦軸の最小値設定
                chart2.ChartAreas[0].AxisY.MajorTickMark.Interval = 1;

                chart2.AntiAliasing = AntiAliasingStyles.None;

                // Seriesの作成と値の追加
                seriesChart2Sign1 = new Series();
                seriesChart2Sign1.ChartType = SeriesChartType.Line;
                seriesChart2Sign1.BorderWidth = 2;
                chart2.Series.Add(seriesChart2Sign1);
                seriesChart2Sign1.Color = System.Drawing.Color.Transparent;   // 透明
                                                                              // 凡例を非表示,各値に数値を表示しない
                chart2.Series[0].IsVisibleInLegend = false;
                chart2.Series[0].IsValueShownAsLabel = false;

                seriesChart2Sign2 = new Series();
                seriesChart2Sign2.ChartType = SeriesChartType.Line;
                seriesChart2Sign2.BorderWidth = 2;
                chart2.Series.Add(seriesChart2Sign2);
                seriesChart2Sign2.Color = System.Drawing.Color.Transparent;   // 透明

                seriesChart2Sign3 = new Series();
                seriesChart2Sign3.ChartType = SeriesChartType.Line;
                seriesChart2Sign3.BorderWidth = 2;
                chart2.Series.Add(seriesChart2Sign3);
                seriesChart2Sign3.Color = System.Drawing.Color.Transparent;   // 透明

                // 凡例を非表示,各値に数値を表示しない
                chart2.Series[0].IsVisibleInLegend = false;
                chart2.Series[0].IsValueShownAsLabel = false;
                chart2.Series[1].IsVisibleInLegend = false;
                chart2.Series[1].IsValueShownAsLabel = false;
                chart2.Series[2].IsVisibleInLegend = false;
                chart2.Series[2].IsValueShownAsLabel = false;

                // 折れ線グラフとして表示
                chart2.Series[0].ChartType = System.Windows.Forms.DataVisualization.Charting.SeriesChartType.FastLine;
                chart2.Series[1].ChartType = System.Windows.Forms.DataVisualization.Charting.SeriesChartType.FastLine;
                chart2.Series[2].ChartType = System.Windows.Forms.DataVisualization.Charting.SeriesChartType.FastLine;
                // 線の色を指定
                chart2.Series[0].Color = System.Drawing.ColorTranslator.FromHtml("#EF810F");
                chart2.Series[1].Color = System.Drawing.ColorTranslator.FromHtml("#00FF00");
                chart2.Series[2].Color = System.Drawing.ColorTranslator.FromHtml("#0ef0f0");
                // 線の太さを指定
                chart2.Series[0].BorderWidth = 2;
                chart2.Series[1].BorderWidth = 2;
                chart2.Series[2].BorderWidth = 2;

                // 凡例を非表示,各値に数値を表示しない
                chart2.Series[0].IsVisibleInLegend = false;
                chart2.Series[0].IsValueShownAsLabel = false;
                chart2.Series[1].IsVisibleInLegend = false;
                chart2.Series[1].IsValueShownAsLabel = false;
                chart2.Series[2].IsVisibleInLegend = false;
                chart2.Series[2].IsValueShownAsLabel = false;

                // チャートに表示させる値の履歴を全て0クリア
                while (countHistory2_1.Count <= MAX_HISTORY)
                {
                    countHistory2_1.Enqueue(0);
                }
                while (countHistory2_2.Count <= MAX_HISTORY)
                {
                    countHistory2_2.Enqueue(0);
                }
                while (countHistory2_3.Count <= MAX_HISTORY)
                {
                    countHistory2_3.Enqueue(0);
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Fatal Error : " + ex.Message, "fmecui Error", MessageBoxButton.OK);
            }
        }
        //=====================================================================
        /// <summary>
        /// 
        /// </summary>
        /// <param name="chart"></param>
        //=====================================================================
        public void RefreshChart1()
        {
            //-----------------------
            // チャートに値をセット
            //-----------------------
            chart1.Series[0].Points.Clear();
            chart1.Series[1].Points.Clear();
            chart1.Series[2].Points.Clear();


            //
            // 左から出力の場合は↓を使う
            //
            foreach (double value in countHistory1_1.Reverse())
            {
                // データをチャートに追加
                chart1.Series[0].Points.Add(new DataPoint(0, value));
            }
            foreach (double value in countHistory1_2.Reverse())
            {
                // データをチャートに追加
                chart1.Series[1].Points.Add(new DataPoint(0, value));
            }
            foreach (double value in countHistory1_3.Reverse())
            {
                // データをチャートに追加
                chart1.Series[2].Points.Add(new DataPoint(0, value));
            }
        }
        //=====================================================================
        /// <summary>
        /// 
        /// </summary>
        /// <param name="chart"></param>
        //=====================================================================
        public void RefreshChart2()
        {
            //-----------------------
            // チャートに値をセット
            //-----------------------
            chart2.Series[0].Points.Clear();
            chart2.Series[1].Points.Clear();
            chart2.Series[2].Points.Clear();


            //
            // 左から出力の場合は↓を使う
            //
            foreach (double value in countHistory2_1.Reverse())
            {
                // データをチャートに追加
                chart2.Series[0].Points.Add(new DataPoint(0, value));
            }
            foreach (double value in countHistory2_2.Reverse())
            {
                // データをチャートに追加
                chart2.Series[1].Points.Add(new DataPoint(0, value));
            }
            foreach (double value in countHistory2_3.Reverse())
            {
                // データをチャートに追加
                chart2.Series[2].Points.Add(new DataPoint(0, value));
            }
        }
        //=====================================================================
        /// <summary>
        /// 
        /// </summary>
        /// <param name="inData"></param>
        //=====================================================================
        public void AddPoint1(double value1, double value2, double value3)
        {
            //------------------------------------------------
            // データのキューイング
            //------------------------------------------------
            countHistory1_1.Enqueue(value1);
            countHistory1_2.Enqueue(value2);
            countHistory1_3.Enqueue(value3);

            //------------------------------------------------
            // 履歴の最大数を超えていたら、古いものを削除する
            //------------------------------------------------
            while (countHistory1_1.Count > MAX_HISTORY)
            {
                countHistory1_1.Dequeue();
            }
            while (countHistory1_2.Count > MAX_HISTORY)
            {
                countHistory1_2.Dequeue();
            }
            while (countHistory1_3.Count > MAX_HISTORY)
            {
                countHistory1_3.Dequeue();
            }
        }
        //=====================================================================
        /// <summary>
        /// 
        /// </summary>
        /// <param name="inData"></param>
        //=====================================================================
        public void AddPoint2(double value1, double value2, double value3)
        {
            //------------------------------------------------
            // データのキューイング
            //------------------------------------------------
            countHistory2_1.Enqueue(value1);
            countHistory2_2.Enqueue(value2);
            countHistory2_3.Enqueue(value3);

            //------------------------------------------------
            // 履歴の最大数を超えていたら、古いものを削除する
            //------------------------------------------------
            while (countHistory2_1.Count > MAX_HISTORY)
            {
                countHistory2_1.Dequeue();
            }
            while (countHistory2_2.Count > MAX_HISTORY)
            {
                countHistory2_2.Dequeue();
            }
            while (countHistory2_3.Count > MAX_HISTORY)
            {
                countHistory2_3.Dequeue();
            }
        }
        //=====================================================================
        /// <summary>
        /// 指定されたデータを表示します。
        /// </summary>
        /// <param name="chart"></param>
        //=====================================================================
        public void SetChartData1(double[] data1, double[] data2, double[] data3)
        {
            //-----------------------
            // チャートに値をセット
            //-----------------------
            chart1.Series[0].Points.Clear();
            chart1.Series[1].Points.Clear();
            chart1.Series[2].Points.Clear();

            //-----------------------
            // 右から出力の場合は↓を使う
            //
            //foreach (short value in data.Reverse())
            //{
            //    // データをチャートに追加
            //    this.Series[0].Points.Add(new DataPoint(0, value));
            //}
            //----------------------

            //
            // 左から出力の場合は↓を使う
            //
            foreach (double value in data1.Reverse())
            {
                // データをチャートに追加
                chart1.Series[0].Points.Add(new DataPoint(0, value));
            }
            foreach (double value in data2.Reverse())
            {
                // データをチャートに追加
                chart1.Series[1].Points.Add(new DataPoint(0, value));
            }
            foreach (double value in data3.Reverse())
            {
                // データをチャートに追加
                chart1.Series[2].Points.Add(new DataPoint(0, value));
            }
        }
        //=====================================================================
        /// <summary>
        /// 指定されたデータを表示します。
        /// </summary>
        /// <param name="chart"></param>
        //=====================================================================
        public void SetChartData2(double[] data1, double[] data2, double[] data3)
        {
            //-----------------------
            // チャートに値をセット
            //-----------------------
            chart2.Series[0].Points.Clear();
            chart2.Series[1].Points.Clear();
            chart2.Series[2].Points.Clear();

            //-----------------------
            // 右から出力の場合は↓を使う
            //
            //foreach (short value in data.Reverse())
            //{
            //    // データをチャートに追加
            //    this.Series[0].Points.Add(new DataPoint(0, value));
            //}
            //----------------------

            //
            // 左から出力の場合は↓を使う
            //
            foreach (double value in data1.Reverse())
            {
                // データをチャートに追加
                chart2.Series[0].Points.Add(new DataPoint(0, value));
            }
            foreach (double value in data2.Reverse())
            {
                // データをチャートに追加
                chart2.Series[1].Points.Add(new DataPoint(0, value));
            }
            foreach (double value in data3.Reverse())
            {
                // データをチャートに追加
                chart2.Series[2].Points.Add(new DataPoint(0, value));
            }
        }
        //=====================================================================
        /// <summary>
        /// クリアします。
        /// </summary>
        //=====================================================================
        public void ClearChart1()
        {
            chart1.Series[0].Points.Clear();
            chart1.Series[1].Points.Clear();
            chart1.Series[2].Points.Clear();
        }
        public void ClearChart2()
        {
            chart2.Series[0].Points.Clear();
            chart2.Series[1].Points.Clear();
            chart2.Series[2].Points.Clear();
        }
        /// <summary>
        /// [DEBUG用] コンソール出力するための定義
        /// </summary>
        /// <returns></returns>
        [DllImport("kernel32.dll", SetLastError = true)]
        [return: MarshalAs(UnmanagedType.Bool)]
        static extern bool AllocConsole();
        /// <summary>
        /// IOサービス操作 [サービス間メッセージ処理] 
        /// サービス開始
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Btn_IO_S_Start_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                //[IoSmpl]サービスにSTART CMDを送る
                //C版 引数(メールボックスハンドル, 自分のサービス名, 自分のサービス名サイズ, コマンド番号、 データ、データサイズ)
                //C#版 引数(相手のサービス名, 自分のサービス名, コマンド番号、 データ(指定なし可))
                int ret = EgProc.EGAPI.EgMailboxSendSC("IoSmpl", EgProc.EGAPI.EGFW.ServiceName, (int)EGDEFINE.EGMSG.EM_SERVICE_RUN);
                if (ret != 0)//0以外の場合は失敗
                {
                    EgProc.EGAPI.EGFW.PrintLog("ERR", "EgMailboxSendSC Error. rtn = {0}", ret.ToString());
                    MessageBox.Show("Error Send IoSmpl Service Start Message");
                }
                else
                    MessageBox.Show("OK Send IoSmpl Service Start Message");
            }
            catch (Exception ex)
            {
                //フレームワーク ログ出力
                EgProc.EGAPI.EGFW.PrintLog("ERR", System.Reflection.MethodBase.GetCurrentMethod().Name + " : " + ex.Message);
            }
        }
        /// <summary>
        /// IOサービス操作 [サービス間メッセージ処理]
        /// サービス中断
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Btn_IO_S_Pause_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                //[IoSmpl]サービスにSPAUSE CMDを送る
                //C版 引数(メールボックスハンドル, 自分のサービス名, 自分のサービス名サイズ, コマンド番号、 データ、データサイズ)
                //C#版 引数(相手のサービス名, 自分のサービス名, コマンド番号、 データ(指定なし可))
                int ret = EgProc.EGAPI.EgMailboxSendSC("IoSmpl", EgProc.EGAPI.EGFW.ServiceName, (int)EGDEFINE.EGMSG.EM_SERVICE_PAUSE);
                if (ret != 0)//0以外の場合は失敗
                {
                    EgProc.EGAPI.EGFW.PrintLog("ERR", "EgMailboxSendSC Error. rtn = {0}", ret.ToString());
                    MessageBox.Show("Error Send IoSmpl Service Pause Message");
                }
                else
                    MessageBox.Show("OK Send IoSmpl Service Pause Message");
            }
            catch (Exception ex)
            {
                //フレームワーク ログ出力
                EgProc.EGAPI.EGFW.PrintLog("ERR", System.Reflection.MethodBase.GetCurrentMethod().Name + " : " + ex.Message);
            }
        }
        /// <summary>
        /// IOサービス操作 [サービス間メッセージ処理]
        /// サービス停止
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Btn_IO_S_Stop_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                MessageBoxResult result = MessageBox.Show("IOサービスを停止します。再度開始はできません。よろしいですか？", "確認", MessageBoxButton.YesNo);
                if (result == MessageBoxResult.Yes)
                {

                    //[IoSmpl]サービスにSTOP CMDを送る
                    //C版 引数(メールボックスハンドル, 自分のサービス名, 自分のサービス名サイズ, コマンド番号、 データ、データサイズ)
                    //C#版 引数(相手のサービス名, 自分のサービス名, コマンド番号、 データ(指定なし可))
                    int ret = EgProc.EGAPI.EgMailboxSendSC("IoSmpl", EgProc.EGAPI.EGFW.ServiceName, (int)EGDEFINE.EGMSG.EM_SERVICE_STOP);
                    if (ret != 0)   //0以外の場合は失敗
                    {
                        EgProc.EGAPI.EGFW.PrintLog("ERR", "EgMailboxSendSC Error. rtn = {0}", ret.ToString());
                        MessageBox.Show("Error Send IoSmpl Service Stop Message");
                    }
                    else
                        MessageBox.Show("OK Send IoSmpl Service Stop Message");
                }
            }
            catch (Exception ex)
            {
                //フレームワーク ログ出力
                EgProc.EGAPI.EGFW.PrintLog("ERR", System.Reflection.MethodBase.GetCurrentMethod().Name + " : " + ex.Message);
            }
        }
        /// <summary>
        /// IOサービス操作 [サービス間メッセージ処理]
        /// IO出力モード 1 設定
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Btn_IO_M_1_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                try
                {
                    //[IoSmpl]サービスにIOMODE 1を送る
                    //C版 引数(メールボックスハンドル, 自分のサービス名, 自分のサービス名サイズ, コマンド番号、 データ、データサイズ)
                    //C#版 引数(相手のサービス名, 自分のサービス名, コマンド番号、 データ(指定なし可))
                    int ret = EgProc.EGAPI.EgMailboxSendSC("IoSmpl", EgProc.EGAPI.EGFW.ServiceName, (int)EM_SERVICE_IO_MODE_1);
                    if (ret != 0)//0以外の場合は失敗
                    {
                        EgProc.EGAPI.EGFW.PrintLog("ERR", "EgMailboxSendSC Error. rtn = {0}", ret.ToString());
                        MessageBox.Show("Error Send IoSmpl Service IO Mode 1 Message");
                    }
                    else
                        MessageBox.Show("OK Send IoSmpl Service IO Mode 1 Message");
                }
                catch (Exception ex)
                {
                    //フレームワーク ログ出力
                    EgProc.EGAPI.EGFW.PrintLog("ERR", System.Reflection.MethodBase.GetCurrentMethod().Name + " : " + ex.Message);
                }
            }
            catch (Exception ex)
            {
                //フレームワーク ログ出力
                EgProc.EGAPI.EGFW.PrintLog("ERR", System.Reflection.MethodBase.GetCurrentMethod().Name + " : " + ex.Message);
            }
        }
        /// <summary>
        /// IOサービス操作 [サービス間メッセージ処理]
        /// WebOpe　タグ 設定　変更
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Btn_web_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                try
                {
                    //[IoSmpl]サービスのWebOpeの値を変更する
                    //C#版 引数(相手のタグ名　書き込む値)
                    int ret = 0;
                    if (lbl_web.Content.ToString() == "WEBアクセス許可中")
                    {
                        ret = EgProc.EGAPI.EgTagWrite("SERVICE.IoSmpl.WebOpe", false);
                        if (ret != 0)//0以外の場合は失敗
                        {
                            EgProc.EGAPI.EGFW.PrintLog("ERR", "EgTagWrite Error. rtn = {0}", ret.ToString());
                            MessageBox.Show("Error WebOpe Tag Write");
                        }
                        else
                            MessageBox.Show("OK WebOpe Tag Write");
                            lbl_web.Content = "WEBアクセス禁止中";
                            btn_web.Content = "許可へ変更";


                    }
                    else
                    {
                        ret = EgProc.EGAPI.EgTagWrite("SERVICE.IoSmpl.WebOpe", true);
                        if (ret != 0)//0以外の場合は失敗
                        {
                            EgProc.EGAPI.EGFW.PrintLog("ERR", "EgTagWrite Error. rtn = {0}", ret.ToString());
                            MessageBox.Show("Error WebOpe Tag Write");
                        }
                        else
                            MessageBox.Show("OK WebOpe Tag Write");
                            lbl_web.Content = "WEBアクセス許可中";
                            btn_web.Content = "禁止へ変更";


                    }
                }
                catch (Exception ex)
                {
                    //フレームワーク ログ出力
                    EgProc.EGAPI.EGFW.PrintLog("ERR", System.Reflection.MethodBase.GetCurrentMethod().Name + " : " + ex.Message);
                }
            }
            catch (Exception ex)
            {
                //フレームワーク ログ出力
                EgProc.EGAPI.EGFW.PrintLog("ERR", System.Reflection.MethodBase.GetCurrentMethod().Name + " : " + ex.Message);
            }
        }

        /// <summary>
        /// IOサービス操作 [サービス間メッセージ処理]
        /// IO出力モード 2 設定
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Btn_IO_M_2_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                try
                {
                    //[IoSmpl]サービスにIOMODE 2を送る
                    //C版 引数(メールボックスハンドル, 自分のサービス名, 自分のサービス名サイズ, コマンド番号、 データ、データサイズ)
                    //C#版 引数(相手のサービス名, 自分のサービス名, コマンド番号、 データ(指定なし可))
                    int ret = EgProc.EGAPI.EgMailboxSendSC("IoSmpl", EgProc.EGAPI.EGFW.ServiceName, (int)EM_SERVICE_IO_MODE_2);
                    if (ret != 0)//0以外の場合は失敗
                    {
                        EgProc.EGAPI.EGFW.PrintLog("ERR", "EgMailboxSendSC Error. rtn = {0}", ret.ToString());
                        MessageBox.Show("Error Send IoSmpl Service IO Mode 2 Message");
                    }
                    else
                        MessageBox.Show("OK Send IoSmpl Service IO Mode 2 Message");
                }
                catch (Exception ex)
                {
                    //フレームワーク ログ出力
                    EgProc.EGAPI.EGFW.PrintLog("ERR", System.Reflection.MethodBase.GetCurrentMethod().Name + " : " + ex.Message);
                }
            }
            catch (Exception ex)
            {
                //フレームワーク ログ出力
                EgProc.EGAPI.EGFW.PrintLog("ERR", System.Reflection.MethodBase.GetCurrentMethod().Name + " : " + ex.Message);
            }
        }
        /// <summary>
        /// IOサービス操作 [サービス間メッセージ処理]
        /// IO出力モード 3 設定
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Btn_IO_M_3_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                try
                {
                    //[IoSmpl]サービスにIOMODE 3を送る
                    //C版 引数(メールボックスハンドル, 自分のサービス名, 自分のサービス名サイズ, コマンド番号、 データ、データサイズ)
                    //C#版 引数(相手のサービス名, 自分のサービス名, コマンド番号、 データ(指定なし可))
                    int ret = EgProc.EGAPI.EgMailboxSendSC("IoSmpl", EgProc.EGAPI.EGFW.ServiceName, (int)EM_SERVICE_IO_MODE_3);
                    if (ret != 0)//0以外の場合は失敗
                    {
                        EgProc.EGAPI.EGFW.PrintLog("ERR", "EgMailboxSendSC Error. rtn = {0}", ret.ToString());
                        MessageBox.Show("Error Send IoSmpl Service IO Mode 3 Message");
                    }
                    else
                        MessageBox.Show("OK Send IoSmpl Service IO Mode 3 Message");
                }
                catch (Exception ex)
                {
                    //フレームワーク ログ出力
                    EgProc.EGAPI.EGFW.PrintLog("ERR", System.Reflection.MethodBase.GetCurrentMethod().Name + " : " + ex.Message);
                }
            }
            catch (Exception ex)
            {
                //フレームワーク ログ出力
                EgProc.EGAPI.EGFW.PrintLog("ERR", System.Reflection.MethodBase.GetCurrentMethod().Name + " : " + ex.Message);
            }
        }
        /// <summary>
        /// コレクタサービス操作 [サービス間メッセージ処理]
        /// サービス開始
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Btn_CLCT_S_Start_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                //[ClctSmpl]サービスにSTART CMDを送る
                //C版 引数(メールボックスハンドル, 自分のサービス名, 自分のサービス名サイズ, コマンド番号、 データ、データサイズ)
                //C#版 引数(相手のサービス名, 自分のサービス名, コマンド番号、 データ(指定なし可))
                int ret = EgProc.EGAPI.EgMailboxSendSC("ClctSmpl", EgProc.EGAPI.EGFW.ServiceName, (int)EGDEFINE.EGMSG.EM_SERVICE_RUN);
                if (ret != 0)//0以外の場合は失敗
                {
                    EgProc.EGAPI.EGFW.PrintLog("ERR", "EgMailboxSendSC Error. rtn = {0}", ret.ToString());
                    MessageBox.Show("Error Send ClctSmpl Service Start Message");
                }
                else
                    MessageBox.Show("OK Send ClctSmpl Service Start Message");
            }
            catch (Exception ex)
            {
                //フレームワーク ログ出力
                EgProc.EGAPI.EGFW.PrintLog("ERR", System.Reflection.MethodBase.GetCurrentMethod().Name + " : " + ex.Message);
            }
        }
        /// <summary>
        /// コレクタサービス操作 [サービス間メッセージ処理]
        /// サービス中断
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Btn_CLCT_S_Pause_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                //[ClctSmpl]サービスにPAUSE CMDを送る
                //C版 引数(メールボックスハンドル, 自分のサービス名, 自分のサービス名サイズ, コマンド番号、 データ、データサイズ)
                //C#版 引数(相手のサービス名, 自分のサービス名, コマンド番号、 データ(指定なし可))
                int ret = EgProc.EGAPI.EgMailboxSendSC("ClctSmpl", EgProc.EGAPI.EGFW.ServiceName, (int)EGDEFINE.EGMSG.EM_SERVICE_PAUSE);
                if (ret != 0)//0以外の場合は失敗
                {
                    EgProc.EGAPI.EGFW.PrintLog("ERR", "EgMailboxSendSC Error. rtn = {0}", ret.ToString());
                    MessageBox.Show("Error Send ClctSmpl Service Pause Message");
                }
                else
                    MessageBox.Show("OK Send ClctSmpl Service Pause Message");
            }
            catch (Exception ex)
            {
                //フレームワーク ログ出力
                EgProc.EGAPI.EGFW.PrintLog("ERR", System.Reflection.MethodBase.GetCurrentMethod().Name + " : " + ex.Message);
            }
        }
        /// <summary>
        /// コレクタサービス操作 [サービス間メッセージ処理]
        /// サービス停止
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Btn_CLCT_S_Stop_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                MessageBoxResult result = MessageBox.Show("コレクタサービスを停止します。再度開始はできません。よろしいですか？", "確認", MessageBoxButton.YesNo);
                if (result == MessageBoxResult.Yes)
                {
                    //[ClctSmpl]サービスにSTOP CMDを送る
                    //C版 引数(メールボックスハンドル, 自分のサービス名, 自分のサービス名サイズ, コマンド番号、 データ、データサイズ)
                    //C#版 引数(相手のサービス名, 自分のサービス名, コマンド番号、 データ(指定なし可))
                    int ret = EgProc.EGAPI.EgMailboxSendSC("ClctSmpl", EgProc.EGAPI.EGFW.ServiceName, (int)EGDEFINE.EGMSG.EM_SERVICE_STOP);
                    if (ret != 0)//0以外の場合は失敗
                    {
                        EgProc.EGAPI.EGFW.PrintLog("ERR", "EgMailboxSendSC Error. rtn = {0}", ret.ToString());
                        MessageBox.Show("Error Send ClctSmpl Service Stop Message");
                    }
                    else
                        MessageBox.Show("OK Send ClctSmpl Service Stop Message");
                }
            }
            catch (Exception ex)
            {
                //フレームワーク ログ出力
                EgProc.EGAPI.EGFW.PrintLog("ERR", System.Reflection.MethodBase.GetCurrentMethod().Name + " : " + ex.Message);
            }
        }
        /// <summary>
        /// コレクタサービス操作 [サービス間メッセージ処理]
        /// コレクタ開始
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Btn_CLCT_C_Start_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                //[ClctSmpl]サービスにCOLLECTOR START CMDを送る
                //C版 引数(メールボックスハンドル, 自分のサービス名, 自分のサービス名サイズ, コマンド番号、 データ、データサイズ)
                //C#版 引数(相手のサービス名, 自分のサービス名, コマンド番号、 データ(指定なし可))
                int ret = EgProc.EGAPI.EgMailboxSendSC("ClctSmpl", EgProc.EGAPI.EGFW.ServiceName, (int)EGDEFINE.EGMSG.EM_COLLECTOR_START_ALL);
                if (ret != 0)//0以外の場合は失敗
                {
                    EgProc.EGAPI.EGFW.PrintLog("ERR", "EgMailboxSendSC Error. rtn = {0}", ret.ToString());
                    MessageBox.Show("Error Send ClctSmpl Service Collector Start Message");
                }
                else
                    MessageBox.Show("OK Send ClctSmpl Service Collector Start Message");
            }
            catch (Exception ex)
            {
                //フレームワーク ログ出力
                EgProc.EGAPI.EGFW.PrintLog("ERR", System.Reflection.MethodBase.GetCurrentMethod().Name + " : " + ex.Message);
            }
        }
        /// <summary>
        /// コレクタサービス操作 [サービス間メッセージ処理]
        /// コレクタ停止
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Btn_CLCT_C_Stop_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                //[ClctSmpl]サービスにCOLLECTOR STOP CMDを送る
                //C版 引数(メールボックスハンドル, 自分のサービス名, 自分のサービス名サイズ, コマンド番号、 データ、データサイズ)
                //C#版 引数(相手のサービス名, 自分のサービス名, コマンド番号、 データ(指定なし可))
                int ret = EgProc.EGAPI.EgMailboxSendSC("ClctSmpl", EgProc.EGAPI.EGFW.ServiceName, (int)EGDEFINE.EGMSG.EM_COLLECTOR_STOP_ALL);
                if (ret != 0)//0以外の場合は失敗
                {
                    EgProc.EGAPI.EGFW.PrintLog("ERR", "EgMailboxSendSC Error. rtn = {0}", ret.ToString());
                    MessageBox.Show("Error Send ClctSmpl Service Collector Stop Message");
                }
                else
                    MessageBox.Show("OK Send ClctSmpl Service Collector Stop Message");
            }
            catch (Exception ex)
            {
                //フレームワーク ログ出力
                EgProc.EGAPI.EGFW.PrintLog("ERR", System.Reflection.MethodBase.GetCurrentMethod().Name + " : " + ex.Message);
            }
        }
        /// <summary>
        /// 描画開始
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Btn_DRAW_Start_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                DrawTimer.Start();
            }
            catch (Exception ex)
            {
                //フレームワーク ログ出力
                EgProc.EGAPI.EGFW.PrintLog("ERR", System.Reflection.MethodBase.GetCurrentMethod().Name + " : " + ex.Message);
            }
        }
        /// <summary>
        /// 描画停止
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Btn_DRAW_Stop_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                DrawTimer.Stop();
            }
            catch (Exception ex)
            {
                //フレームワーク ログ出力
                EgProc.EGAPI.EGFW.PrintLog("ERR", System.Reflection.MethodBase.GetCurrentMethod().Name + " : " + ex.Message);
            }
        }
        /// <summary>
        /// Tag情報取得 表示
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Btn_TagGet_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                CCmbItem item = (CCmbItem)cmbTags.SelectedItem;
                if(item != null && item.TagName.Length > 0)
                {
                    object objType = new object();
                    int ret = EgProc.EGAPI.EgTagGetProperty(item.TagName, "Type", ref objType);
                    if (ret == 0)
                        type.Text = objType.ToString();         //type
                    else
                        EgProc.LOG("Error EgTagGetProperty Type");
                    //アドレスの取得
                    object stAddress = "";
                    ret = EgProc.EGAPI.EgTagGetProperty(item.TagName, "Address", ref stAddress);
                    if (ret == 0)
                        address.Text = stAddress.ToString();    //addressテキストボックスに入力
                    else
                        EgProc.LOG("Error EgTagGetProperty Source");

                    //コメントの取得
                    object stComment = "";
                    ret = EgProc.EGAPI.EgTagGetProperty(item.TagName, "Comment", ref stComment);
                    if (ret == 0)
                        comment.Text = stComment.ToString();    //commentテキストボックスに入力
                    else
                        EgProc.LOG("Error EgTagGetProperty Comment");
                }
            }
            catch (Exception ex)
            {
                //フレームワーク ログ出力
                EgProc.EGAPI.EGFW.PrintLog("ERR", System.Reflection.MethodBase.GetCurrentMethod().Name + " : " + ex.Message);
            }
        }
        /// <summary>
        /// unicodeからshiftjisに変換
        /// </summary>
        /// <param name="unicodeStrings"></param>
        /// <returns></returns>
        private string ToShiftJis(string unicodeStrings)
        {
            try
            {
                Encoding unicode = Encoding.Unicode;                                                //Unicode
                byte[] unicodeByte = unicode.GetBytes(unicodeStrings);                              //Unicodeの文字列をバイトに
                Encoding s_jis = Encoding.GetEncoding("shift_jis");                                 //shift_jis
                byte[] s_jisByte = Encoding.Convert(unicode, s_jis, unicodeByte);                   //unicodeのbyte配列をsjisのバイト配列に
                char[] s_jisChars = new char[s_jis.GetCharCount(s_jisByte, 0, s_jisByte.Length)];   //sjisのbyte配列からsjisの文字列配列に
                s_jis.GetChars(s_jisByte, 0, s_jisByte.Length, s_jisChars, 0);                      //最後string型に
                return new string(s_jisChars);
            }
            catch (Exception ex)
            {
                //フレームワーク ログ出力
                EgProc.EGAPI.EGFW.PrintLog("ERR", System.Reflection.MethodBase.GetCurrentMethod().Name + " : " + ex.Message);
                return "";
            }
        }
    }
    // <summary>
    /// コンボボックス表示情報クラス
    /// </summary>
    public class CCmbItem
    {
        public override string ToString()
        {
            return _TagName;
        }
        /// <summary>
        /// 表示名
        /// </summary>
        private string _TagName;
        /// <summary>
        /// 表示名
        /// </summary>
        public string TagName
        {
            get { return _TagName; }
            set { _TagName = value; }
        }
    }

}
