﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using RTedge; // RT edge system API
using EdgeCode; // RT edge template code

namespace IOSample
{
    /// <summary>
    /// Tag読み込みサービス画面
    /// </summary>
    public partial class MainWindow : Window
    {
        #region フィールド

        /// <summary>
        /// // RTedge フレームワーク +API を使用したコードクラス
        /// </summary>
        private edgeCode EgProc = null;

        /// <summary>
        /// // RT-edge APIクラス
        /// </summary>
        private edge_API EGAPI = null;

        /// <summary>
        /// 周期的に読込むTag
        /// </summary>
        private static string TAG_INPUT_VALUE = "SERVICE.IOSample.Live";        // [TODO] 目的のTagに変更してください。

        /// <summary>
        /// Writeボタンで書き込むTag
        /// </summary>
        private static string TAG_OUTPUT_VALUE = "SERVICE.IOSample.WriteTest";  // [TODO] 目的のTagに変更してください。

        #endregion


        /// <summary>
        /// コンストラクタ
        /// </summary>
        public MainWindow()
        {
            // Component の初期化 自動生成コード
            InitializeComponent();          

            // アクセスするTagを画面上に表示
            txtInputTAG.Text = TAG_INPUT_VALUE;
            txtOutputTAG.Text = TAG_OUTPUT_VALUE;

            // RT-edge初期化処理
            EGAPI  = new edge_API();                            // RT-edge APIクラス インスタンス化
            EgProc = new edgeCode();                            // RT-edge 処理クラスの作成
            EgProc.mInstMainClose += Stop;                      // フレームワーク内終了メッセージ処理時の関数指定
            EgProc.mRefleshEvent += MainWindow_refleshEvent;    // 値更新イベントの登録
            EgProc.InitService(TAG_INPUT_VALUE);                // RT-edge 処理クラスの初期化
        }


        #region パブリックメソッド

        /// <summary>
        /// 画面終了処理
        /// </summary>
        public void Stop()
        {
            try
            {
                Dispatcher.Invoke((Action)(() =>
                {
                    Close();                        //Window Close関数呼び出し
                }));
            }
            catch (Exception ex)
            {
                EgProc.LOG(System.Reflection.MethodBase.GetCurrentMethod().Name + " : " + ex.Message);
            }
        }

        #endregion


        #region イベントハンドラ

        /// <summary>
        /// Writeボタンクリックイベントハンドラ
        /// 画面から入力された値をTagに書きこみます。
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void BtnOutput_Click(object sender, RoutedEventArgs e)
        {
            uint value = 0;
            string outvalueStr = txtOutput.Text;
            if (uint.TryParse(outvalueStr, out value))
            {
                // 値の書込み
                EGAPI.EgTagWrite(TAG_OUTPUT_VALUE, value);
            }
        }

        /// <summary>
        /// 開始ボタンクリックイベントハンドラ。
        /// Tag読み込み処理を開始します。
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void BtnStart_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                // サービスを開始します
                EgProc.StartService();
            }
            catch (Exception ex)
            {
                EgProc.LOG(System.Reflection.MethodBase.GetCurrentMethod().Name + " : " + ex.Message);
            }
        }

        /// <summary>
        /// 停止ボタンクリックイベントハンドラ
        /// Tag読み込み処理を終了します。
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void BtnStop_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                // サービスを一時停止します
                EgProc.PauseService();
            }
            catch (Exception ex)
            {
                EgProc.LOG(System.Reflection.MethodBase.GetCurrentMethod().Name + " : " + ex.Message);
            }
        }

        /// <summary>
        /// サービス（Tag読み込みスレッド）からの値更新イベントハンドラ
        /// サービスが読込んだ値を画面に表示します。
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void MainWindow_refleshEvent(object sender, RefleshValueInputEventArgs e)
        {
            // 読込んだ値を画面へ表示
            txtInput.Text = e.Value.ToString();
        }

        /// <summary>
        /// 画面Closeイベントハンドラ
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Window_Closing(object sender, System.ComponentModel.CancelEventArgs e)
        {
            try
            {
                EgProc.KillService();           //サービス削除関数呼び出し<必須>
                EgProc.EGAPI.EgFinalize();      //APIのFinalize処理追加 <必須>
                EgProc.Release();               //後処理
            }
            catch (Exception ex)
            {
                EgProc.LOG(System.Reflection.MethodBase.GetCurrentMethod().Name + " : " + ex.Message);
            }
        }

        #endregion

    }
}
