@echo off
@SET NODENAME=NodeA
@SET LOADER="%INTIME%bin\ldrta.exe"
@SET WAITCTG="%INTIME%bin\waitfor.exe"

REM ********************************
REM EtherCAT Driver Load Setting
@SET ECATUSE=1
@SET ECATDRV="%RSIECAT%bin\RtEcHdr.rta"
@SET ECATARG="-cycle=eni"
@SET ECATINIT="PRCS_RTECHDR"
@SET ECATWAIT=32

REM ********************************
REM FL-net Driver Load Setting
@SET FLNETUSE=0
@SET FLNETDRV="%RSI040%bin\RSI040.rta"
@SET FLNETARG=""
@SET FLNETINIT="RTFLNET"
@SET FLNETWAIT=32

REM ********************************
REM CC-Link IE Driver Load Setting
@SET CCIEUSE=0
@SET CCIEDRV="%RSICCIE%bin\RSICCIED.rta"
@SET CCIEARG=""
@SET CCIEINIT="RSICCIE_DRV"
@SET CCIEWAIT=32

REM ********************************
REM cifX Driver(EtherNet/IP) Load Setting
@SET ETHIPUSE=0
@SET ETHIPDRV="%INTIME%bin\cifxdrv.rta"
@SET ETHIPARG=""
@SET ETHIPINIT="CIFXDrv"
@SET ETHIPWAIT=32

REM ********************************
REM Software PLC Load Setting
@SET PLCUSE=1
@SET PLCDRV="%INplcRT%INpMgr.rta"
@SET PLCARG=""
@SET PLCINIT="ProConOS"
@SET PLCWAIT=32


REM ********************************
REM Start INtime Kernel
@CALL "StartRTK.bat" %NODENAME% -v

REM ********************************
REM Start Drivers
if %ECATUSE%  neq 0 ( @CALL :LoadRtProcess %ECATDRV%  %ECATARG%  %ECATWAIT%  %ECATINIT%  )
if %FLNETUSE% neq 0 ( @CALL :LoadRtProcess %FLNETDRV% %FLNETARG% %FLNETWAIT% %FLNETINIT% )
if %CCIEUSE%  neq 0 ( @CALL :LoadRtProcess %CCIEDRV%  %CCIEARG%  %CCIEWAIT%  %CCIEINIT%  )
if %ETHIPUSE% neq 0 ( @CALL :LoadRtProcess %ETHIPDRV% %ETHIPARG% %ETHIPWAIT% %ETHIPINIT% )

REM ********************************
REM Start RT-edge sequence
@pushd %~dp0
@CD "%RTEDGE%\bin"
@START EgBoot.exe
@popd

REM ********************************
REM Start PLC engine
if %PLCUSE%  neq 0 ( @CALL :LoadRtProcess %PLCDRV% %PLCARG% %PLCWAIT% %PLCINIT%  )

exit /b


REM ********************************
:LoadRtProcess
@%LOADER% %1 -a %2
@%WAITCTG% -node %NODENAME% -wait %3 %4
exit /b