/*****************************************************************************
* egAPI.h
*
*   RT-edge system API header file
*
*     Copyright(C) 2020 Micronet Co. All Rights Reserved.
\*****************************************************************************/

#pragma once
#include <stdint.h>
#include <stdbool.h>
#include "edgeAPI_RTCD.h"
#ifdef __cplusplus
extern "C"
{
#endif

#ifdef  edge_API_EXPORTS
#define edge_API 
#else
#define edge_API __declspec(dllimport)
#endif

//------------------------------------------------------------------------------
// G[R[h
//------------------------------------------------------------------------------
#define EDGE_SUCCESS							0x00000000	// I
#define EDGE_LOCATION_ERROR						0x80000001	// P[Vnh擾G[
#define EDGE_KERNEL_NOT_RUNNING					0x80000002	// J[lNĂ܂
#define EDGE_ROOTPROCESS_ERROR					0x80000003	// [gvZX擾G[
#define EDGE_PARAM_INVALID						0x80000004	// p[^sł
#define EDGE_THREAD_ERROR						0x80000005	// XbhJnG[


// RTCD֘A
#define EDGE_RTCD_NAME_INVALID					0x80000100	// RTCD̂sł
#define EDGE_RTCD_NAME_LENGTH_ERROR				0x80000101	// RTCD̂̕G[
#define EDGE_RTCD_RECORD_LENGTH_ERROR			0x80000102	// R[hG[
#define EDGE_RTCD_RECORD_NUM_ERROR				0x80000103	// R[hG[
#define EDGE_RTCD_WRITE_MODE_ERROR				0x80000105	// ݃[hG[
#define EDGE_RTCD_EXIST_ERROR					0x80000106	// ɓRTCD݂܂
#define EDGE_RTCD_NOT_EXIST_ERROR				0x80000107	// RTCD݂܂
#define EDGE_RTCD_NAME_EXIST_ERROR				0x80000108	// ɓOgĂ܂
#define EDGE_RTCD_ALLOCATE_ERROR				0x80000109	// mێs
#define EDGE_RTCD_FREE_ERROR					0x8000010A	// s
#define EDGE_RTCD_CREATE_MEM_HANDLE_ERROR		0x8000010B	// nhs
#define EDGE_RTCD_DELETE_MEM_HANDLE_ERROR		0x8000010C	// nh폜s
#define EDGE_RTCD_CATALOG_ERROR					0x8000010D	// J^Os
#define EDGE_RTCD_UNCATALOG_ERROR				0x8000010E	// AJ^Os
#define EDGE_RTCD_LOOKUP_ERROR					0x8000010F	// bNAbvs
#define EDGE_RTCD_MAPPING_ERROR					0x80000110	// }bsOs
#define EDGE_RTCD_UNMAPPING_ERROR				0x80000111	// A}bsOs
#define EDGE_RTCD_ACCESS_MODE_ERROR				0x80000112	// ANZX[hG[
#define EDGE_RTCD_ALREADY_OPEN_READ_ERROR		0x80000113	// ɓǍ݃ANZXŃI[vĂ܂
#define EDGE_RTCD_ALREADY_OPEN_WRITE_ERROR		0x80000114	// ɏ݃ANZXŃI[vĂ܂(VO[h)
#define EDGE_RTCD_MEMINFO_INVALID				0x80000115	// RTCD񂪕sł
#define EDGE_RTCD_HANDLE_INVALID				0x80000116	// nhsł
#define EDGE_RTCD_BUFFER_INVALID				0x80000117	// obt@sł
#define EDGE_RTCD_BUFFER_SIZE_INVALID			0x80000118	// obt@TCYsł
#define EDGE_RTCD_WRITE_SIZE_INVALID			0x80000119	// ݃TCYsł
#define EDGE_RTCD_RECORD_HEADER_INVALID			0x8000011A	// RTCDwb_[sł
#define EDGE_RTCD_INFO_INVALID					0x8000011B	// RTCD񂪕sł
#define EDGE_RTCD_NO_UPDATE						0x8000011C	// f[^XV܂
#define EDGE_RTCD_BUFFER_FULL_ERROR				0x8000011D	// obt@tG[
#define EDGE_RTCD_CREATE_LOGMBOX_ERROR			0x8000011E	// OpMAILBOXs
#define EDGE_RTCD_PROPERTY_NOT_SUPPORT			0x8000011F	// w肵vpeB̓T|[gĂ܂
#define EDGE_RTCD_CANNOT_GET_ENTRY				0x80000120	// ^O̐EEntry擾ł܂B

#define EDGE_RTCD_CREATE_SEMAPHORE1_ERROR		0x80000200	// Z}tHG[(rpZ}tH)
#define EDGE_RTCD_CREATE_SEMAPHORE2_ERROR		0x80000201	// Z}tHG[(ʒmpZ}tH)
#define EDGE_RTCD_DELETE_SEMAPHORE1_ERROR		0x80000202	// Z}tH폜G[(rpZ}tH)
#define EDGE_RTCD_DELETE_SEMAPHORE2_ERROR		0x80000203	// Z}tH폜G[(ʒmpZ}tH)
#define EDGE_RTCD_CATALOG_SEMAPHORE1_ERROR		0x80000204	// Z}tHJ^OG[(rpZ}tH)
#define EDGE_RTCD_CATALOG_SEMAPHORE2_ERROR		0x80000205	// Z}tHJ^OG[(ʒmpZ}tH)
#define EDGE_RTCD_SEMAPHORE_TIMEOUT				0x80000206	// Z}tH擾^CAEg
#define EDGE_RTCD_WAIT_SEMAPHORE_ERROR			0x80000207	// Z}tH擾G[
#define EDGE_RTCD_RELEASE_SEMAPHORE_ERROR		0x80000208	// Z}tHG[
#define EDGE_RTCD_OPEN_SEMAPHORE1_ERROR			0x80000209	// Z}tHI[vG[(rpZ}tH)
#define EDGE_RTCD_OPEN_SEMAPHORE2_ERROR			0x8000020A	// Z}tHI[vG[(ʒmpZ}tH)
#define EDGE_RTCD_NOT_EXIST_SEMAPHORE_ERROR		0x8000020B	// Z}tH݂܂
#define EDGE_RTCD_LOOKUP_SEMAPHORE_ERROR		0x8000020C	// Z}tHbNAbvG[
#define EDGE_RTCD_SEMAPHORE1_EXIST_ERROR		0x8000020D	// ɓZ}tH݂܂(rpZ}tH)
#define EDGE_RTCD_SEMAPHORE1_NAME_EXIST_ERROR	0x8000020E	// ɓOgĂ܂(rpZ}tH)
#define EDGE_RTCD_SEMAPHORE2_EXIST_ERROR		0x8000020F	// ɓZ}tH݂܂(ʒmpZ}tH)
#define EDGE_RTCD_SEMAPHORE2_NAME_EXIST_ERROR	0x80000210	// ɓOgĂ܂(ʒmpZ}tH)
#define EDGE_RTCD_OSDEP_CREATE_SEMAPHORE_ERROR	0x80000211	// Z}tHG[(ʊ֐)
#define EDGE_RTCD_OSDEP_DELETE_SEMAPHORE_ERROR	0x80000212	// Z}tH폜G[(ʊ֐)
#define EDGE_RTCD_OSDEP_SEMAPHORE_TIMEOUT		0x80000213	// Z}tH擾^CAEg
#define EDGE_RTCD_OSDEP_WAIT_SEMAPHORE_ERROR	0x80000214	// Z}tH擾G[
#define EDGE_RTCD_OSDEP_RELEASE_SEMAPHORE_ERROR	0x80000215	// Z}tHG[

#define EDGE_RTCD_ARG_DATA_SIZE_ERROR			0x80000300	// w肵̕ϐTCỸTCY傫,܂͏߃obt@

#define EDGE_TTABLE_MEMORRY_ERROR					0x80000400	// ̍쐬łȂ(INtimȅꍇ̓J[lNĂȂ)
#define EDGE_TTABLE_EXIST_ERROR						0x80000401	// ɓTAGINFOTABLE݂܂
#define EDGE_TTABLE_CREATE_FILEMAPPING_ERROR		0x80000402	// t@C}bsOG[
#define EDGE_TTABLE_MAP_VIEW_ERROR					0x80000403	// r[}bvG[
#define EDGE_TTABLE_MEMINFO_INVALID					0x80000404	// TTable񂪕sł
#define EDGE_TTABLE_UNMAP_VIEW_ERROR				0x80000405	// r[A}bvG[
#define EDGE_TTABLE_CREATE_MEM_HANDLE_ERROR			0x80000406	// nhs
#define EDGE_TTABLE_DELETE_MEM_HANDLE_ERROR			0x80000407	// nh폜s
#define EDGE_TTABLE_OPEN_FILEMAPPING_ERROR			0x80000408	// t@C}bsOI[vG[
#define EDGE_TTABLE_ISEXIST_TAGNAME					0x80000409	// o^ς
#define EDGE_TTABLE_NOEXISTT_TAGNAME				0x8000040A	// w肵^O^Oe[uɑ݂ȂB
#define EDGE_TTABLE_HASH_ERROR						0x8000040B	// nbVlsłB
#define EDGE_TTABLE_INDEX_ERROR						0x8000040C	// IndexlsłB
#define EDGE_TTABLE_DATA_ERROR						0x8000040D	// f[^l݂܂B
#define EDGE_TTABLE_NOEMPTY							0x8000040E	// e[uɋ󂫂܂B
#define EDGE_TTABLE_VALUE_OVERFLOW					0x8000040F	// /Ǎf[^TCYsłB
#define EDGE_TTABLE_NAME_EXIST_ERROR				0x80000410	// O݂Ă
#define EDGE_TTABLE_CATALOG_ERROR					0x80000411	// J^OɎs
#define EDGE_TTABLE_LOOKUP_ERROR					0x80000412	// LOOKUPs
#define EDGE_TTABLE_MAPPING_ERROR					0x80000413	// }bsOs
#define EDGE_TTABLE_NOT_EXIST_ERROR					0x80000414	// GgOȂ̂ɁAGgȂs
#define EDGE_TTABLE_FREE_ERROR						0x80000415	// t[s
#define EDGE_TTABLE_TYPE_ERROR						0x80000416	// Taǧ^^Cv͈͊O
#define EDGE_TTABLE_DATASIZE_ERROR					0x80000417	// Tag̃f[^TCY͈͊O
#define EDGE_TTABLE_DUPLICATE_ERROR					0x80000418	// Tag̏do^NG
#define EDGE_TTABLE_RESET_DEFAULT_VALUE				0x80000419	// Tag̏lZbgs
#define EDGE_TTABLE_RESET_DEFAULT_VALUE_TIMEOUT		0x8000041A	// Tag̏lZbgsA^CAEg
#define EDGE_TTABLE_NOEXISTT_DSETNAME				0x80000501	// w肳ꂽDataset̓e[uɑ݂Ȃ
#define EDGE_TTABLE_NOEXISTT_DSETITEM				0x80000502	// w肳ꂽDatasetɂTago^ĂȂ
#define EDGE_TTABLE_TAG_IS_NULL						0x80000503	// nextTag݂͑Ȃ
#define EDGE_TTABLE_SERVICE_INDEX_NULL				0x80000504	// ServiceIndexĂȂ
#define EDGE_TTABLE_SYSTEM_CONFIG_NULL				0x80000505	// IuWFNglL쐬łȂ
#define EDGE_TTABLE_NOT_EXIST_EGIO					0x80000506	// EdgeIO|[g񂪑݂Ȃ

#define EDGE_FAILED_TO_START_PROCESS                0x80000601	// vZXJnł܂ł

// Framework֘A
#define EDGE_FW_INIT_ERROR							0x80001001  //FATALG[(t[[NƂēłȂłB̃G[mFĂ						
#define EDGE_FW_NAME_INVALID						0x80001002	//T[rX́ivZX)sł
#define EDGE_FW_XML_FORMAT_ERROR					0x80001003  //XMLtH[}bgG[						
#define EDGE_FW_COLLECTOR_ALREADY_WORKING			0x80001004  //RN^͊ɓ삵Ă܂B						
#define EDGE_FW_OBJECT_NOTEXIST						0x80001005  //w肵IuWFNg݂͑Ȃ					
#define EDGE_FW_MESSAGE_NOTEXIST					0x80001006  //w肵c[ԒʐMbZ[W݂͑Ȃ
#define EDGE_FW_DUPLICATE_OBJECT					0x80001007	//̃IuWFNg݂
#define EDGE_FW_OBJECT_SIZE_OVER					0x80001008	//IuWFNgl𒴂܂/Ă܂

// ʊ֐֘A
#define EGDE_COMMON_DECODE_FORMAT_CMPIDENT_ERR		0x80002001  //DecodẽAhX(format)s(rGg̎ʎq)
#define EGDE_COMMON_DECODE_FORMAT_PRIOD1_ERR		0x80002002  //DecodẽAhX(format)s(sIhw肪ׂƂɂȂ)
#define EGDE_COMMON_DECODE_FORMAT_PRIOD2_ERR		0x80002003  //DecodẽAhX(format)s(sIh̎w肪Ȃ)
#define EGDE_COMMON_DECODE_FORMAT_PRIOD3_ERR		0x80002004  //DecodẽAhX(format)s(sIhlI[o[)
#define EGDE_COMMON_DECODE_FORMAT_PRIOD4_ERR		0x80002005  //DecodẽAhX(format)s(sIhlI[o[)
#define EGDE_COMMON_DECODE_FORMAT_DST_BUFFERR		0x80002006  //DecodẽAhX(format)s(dstobt@)
#define EGDE_COMMON_DECODE_FORMAT_OFFSET1_ERR		0x80002007  //DecodẽAhX(format)s(sK؂ȃItZbgʒu)
#define EGDE_COMMON_DECODE_FORMAT_OFFSET2_ERR		0x80002008  //DecodẽAhX(format)s(srcobt@offsetw肪)

#define EDGE_MODULE_LOAD_ERROR						0x80003001	//W[̃[hs

// ^O|C^֘A									0x80004001 ... 
#define	EDGE_TAGPTR_CREATE_ERROR					0x80004001	// ^O|C^pq[v̈̐łȂ
#define	EDGE_TAGPTR_MAP_ERROR						0x80004002	// ^O|C^pq[v̈̃}bvłȂ
#define	EDGE_TAGPTR_EXIST_ERROR						0x80004003	// Ƀ^O|C^pq[v̈悪݂܂
#define	EDGE_TAGPTR_COUNT_OVER						0x80004004	// ^O|C^o^ő吔̂߁A^O|C^o^łȂ
#define EDGE_TAGPTR_NO_FREE_SPACE					0x80004005	// ^O|C^pq[v̈̋󂫗eʂȂ߁A^O|C^o^łȂ
#define EDGE_TAGPTR_SIZE_ZERO						0x80004006	// TCY0w肳ꂽ
#define EDGE_TAGPTR_SIZE_UNMATCH					0x80004007	// N^ÕTCYsv
#define EDGE_TAGPTR_SIZE_OVERFLOW					0x80004008	// /ǂݍ݃f[^TCYsłB
#define EDGE_TAGPTR_TYPE_UNMATCH					0x80004009	// ^O^Cvsv
#define EDGE_TAGPTR_OFFSET_OVERFLOW					0x8000400A	// ItZbg͈͊O
#define EDGE_TAGPTR_BUFFER_NULL						0x8000400B	// obt@NULLw肳ꂽ
#define EDGE_TAGPTR_LOCK_TIMOUT						0x8000400C	// /ǂݍݎs

// L֘A
#define EDGE_SHM_ALLOCATE_ERROR						0x80005001	// [Jmێs
#define EDGE_SHM_MAP_ERROR							0x80005002	// L̈̃}bvłȂ
#define	EDGE_SHM_EXIST_ERROR						0x80005003	// ɋLǗςł܂
#define EDGE_SHM_PARAM_INVALID						0x80005004	// p[^sł
#define	EDGE_SHM_LTB_FULL							0x80005005	// [Je[ű󂫖
#define	EDGE_SHM_MAX_TAGS_NUM						0x80005006	// Tag̍őTCY擾s
#define	EDGE_SHM_NO_MAPPED							0x80005007	// }bvĂȂ
#define EDGE_SHM_TYPE_UNMATCH						0x80005009	// ^O^Cvsv
#define EDGE_SHM_OFFSET_OVERFLOW					0x8000500A	// ItZbg{TCY}bvTCY͈͊O
#define EDGE_SHM_SYNTAX1_ERROR						0x80005ADA	// LAddress\G[1
#define EDGE_SHM_SYNTAX2_ERROR						0x80005ADB	// LAddress\G[2
#define EDGE_SHM_SYNTAX3_ERROR						0x80005ADC	// LAddress\G[3
#define EDGE_SHM_SYNTAX4_ERROR						0x80005ADD	// LAddress\G[4
#define EDGE_SHM_SYNTAX5_ERROR						0x80005ADE	// LAddress\G[5
#define EDGE_SHM_SYNTAX6_ERROR						0x80005ADF	// LAddress\G[6

// FIFO^O֘A
#define EDGE_FIFO_UNDERRUN							0x80006001	// FIFOobt@̃A_(擾V[PX󂵂Ƃ)
#define EDGE_FIFO_OVERRUN							0x80006002	// FIFOobt@̃I[o(Âf[^j󂵂 / ǂݎ̂ĂƂ)
#define EDGE_FIFO_TAG_ERROR							0x80006003	// ^O̓G[(FIFO^OL^Oł͂Ȃ)

#pragma pack(push,1)

//------------------------------------------------------------------------------
// Spinlock`
//------------------------------------------------------------------------------
	typedef struct tEgSpinlock
	{
		uint32_t		current;				// 
		uint32_t		limit;					//  (current==limit)free
	}EGSPINLOCK, *HEGSPINLOCK;

	void _EgInitializeSpinLock(HEGSPINLOCK spin);
	void _EgAcquireSpinLock(HEGSPINLOCK spin);
	void _EgReleaseSpinLock(HEGSPINLOCK spin);

//------------------------------------------------------------------------------
// EgIuWFNgQƗpCfbNX`
//------------------------------------------------------------------------------
	typedef struct tEdgeIndex
	{
		uint32_t	hint;						// \(VXep)
		uint32_t	offset;						// ACeւ̃oCgItZbg
	}EDGE_INDEX, *LPEDGE_INDEX;

//------------------------------------------------------------------------------
// EgVARIANTIuWFNg`
//------------------------------------------------------------------------------

	//
	// ^(Ver3.1_ Ή gp֎~
	//

	typedef struct EgBSTR
	{
		uint16_t		len;
		char			string[1];
	}*EGBSTR;

// EgStringAlloc
// EgStringFree
// EgStringLen

	//
	// EgTag f[^^萔
	//
	enum egTagDataType
	{
		EgVtNull = 99,
		EgVtEmpty = 0,
		EgVtBoolean = 1,
		EgVtSByte = 2,
		EgVtByte = 3,
		EgVtInt16 = 4,
		EgVtUInt16 = 5,
		EgVtInt32 = 6,
		EgVtUInt32 = 7,
		EgVtInt64 = 8,
		EgVtUInt64 = 9,
		EgVtFloat = 10,
		EgVtDouble = 11,
		EgVtString = 12,
		EgVtSegment = 13,
		EgVtFIFO = 14,
	};

	//
	// EGVARIANT^
	//

	typedef struct EgVARIANT {
		struct {
			uint16_t	vt;								// Value Type 
			uint16_t	size;							// Size
			EGSPINLOCK	lock;							// (Internal Use) Exclusive control flag
			union {
				union EgVARIANTValues
				{
					bool		boolVal;
					float		fltVal;
					double		dblVal;
					time_t		date;
					char		cVal;
					int16_t		iVal;
					int32_t		lVal;
					int32_t		intVal;
					int64_t		llVal;
					uint8_t		bVal;
					uint16_t	uiVal;
					uint32_t	ulVal;					// Segment: (Internal Use) Offset value from the top by edge-segment
					uint32_t	uintVal;
					uint64_t	ullVal;
					bool		*pboolVal;
					float		*pfltVal;
					double		*pdblVal;
					time_t		*pdate;
					char		*pcVal;
					int16_t		*piVal;
					int32_t		*plVal;
					int32_t		*pintVal;
					int64_t		*pllVal;
					uint8_t		*pbVal;
					uint16_t	*puiVal;
					uint32_t	*pulVal;
					uint32_t	*puintVal;
					uint64_t	*pullVal;
					void		*byref;
					EGBSTR		*pStr;
					struct EgVARIANT		*pvarVal;
				};
				intptr_t	val;
			} ;
			uint64_t	pSegment;						// Segment     : Base address + offset value
														// SharedMemory: Base address + offset value
		} ;
	} EGVAR;

	//------------------------------------------------------------------------------
	// APIp萔
	//------------------------------------------------------------------------------

	//
	// VXebZ[W
	// egapiWrap/EGDEFINE.csčXVĂB
	//
	enum EDGE_MSG
	{
		EM_RETURN_RECEIVE_OK = 1,					// pbZ[WiԐM˗悤ȃP[X)
		EM_SERVICE_STOP = 101,						// T[rXXgbvbZ[W
		EM_SERVICE_RUN = 102,						// T[rXsJnw
		EM_SERVICE_PAUSE = 103,						// T[rXs~w
		EM_SERVICE_UPDATE = 104,					// f[^tbVw
		EM_SERVICE_ADD_TAG = 111,					// T[rXEgTagRefǉ
		EM_SERVICE_REMOVE_TAG = 112,				// T[rXEgTagRef폜(Ver.3.1ł͖ ȍ~gp)
		EM_SERVICE_CLEAR_TAG = 113,					// T[rXEgTagRefI[NA(Ver.3.1ł͖ ȍ~gp)
		EM_SERVICE_ADD_OUT_TAG = 114,				// T[rXEgTagRef_OUTǉ
		EM_SERVICE_REMOVE_OUT_TAG = 115,			// T[rXEgTagRef_OUT폜(Ver.3.1ł͖ ȍ~gp)
		EM_SERVICE_CLEAR_OUT_TAG = 116,				// T[rXEgTagRef_OUTI[NA(Ver.3.1ł͖ ȍ~gp)
		EM_SERVICE_ADD_IN_TAG = 117,				// T[rXEgTagRef_INǉ
		EM_SERVICE_REMOVE_IN_TAG = 118,				// T[rXEgTagRef_IN폜(Ver.3.1ł͖ ȍ~gp)
		EM_SERVICE_CLEAR_IN_TAG = 119,				// T[rXEgTagRef_INI[NA
		EM_SERVICE_ADD_CLCTREF = 121,				// T[rXEgCollectorRefǉ
		EM_SERVICE_REMOVE_CLCTREF = 122,			// T[rXEgCollectorRef폜(Ver.3.1ł͖ ȍ~gp)
		EM_SERVICE_CLEAR_CLCTREF = 123,				// T[rXEgCollectorRefI[NA(Ver.3.1ł͖ ȍ~gp)
		EM_SERVICE_ADD_MBOX = 124,					// T[rXEgMailboxǉ
		EM_SERVICE_REMOVE_MBOX = 125,				// T[rXEgMailbox폜
		EM_SERVICE_ADD_TAGTRIGGER = 126,			// T[rXTagTriggerǉ
		EM_SERVICE_READ_TAGTRIG_FINISH = 127,		// T[rXTagTriggerݒǂݍ݊
		EM_SERVICE_ADD_MESSAGEOBJ = 128,			// T[rXMessageObjǉ
		EM_COLLECTOR_CREATE = 201,					// RN^쐬bZ[W
		EM_COLLECTOR_START_ALL = 202,				// T[rXRN^SX^[gbZ[W
		EM_COLLECTOR_STOP_ALL = 203,				// T[rXRN^SXgbvbZ[W
		EM_COLLECTOR_START_ONE = 204,				// T[rXRN^X^[gbZ[W(RN^w)
		EM_COLLECTOR_STOP_ONE = 205,				// T[rXRN^XgbvbZ[W(RN^w)
		EM_COLLECTOR_WRITED_DATA = 206,				// T[rXRN^f[^ݎ̃bZ[WID
		EM_TAGTRIGGER_NOTIFICATION = 250,			// gK[Ώۃ^Olωʒm
		EM_TAGTRIGGER_START = 251,					// ^OgK[XbhX^[gbZ[W
		EM_READ_REQUEST_SERVICE_XML = 1000,			// t[[N xmlǂݍݖ߃bZ[W
		EM_READ_REQUEST_SERVICE_XML_END = 1001,		// T[rXƃt[[NxmlǂݍݖߎMAxmlǂݏIƂɃT[rXɑM郁bZ[W
		EM_READ_XML_SERVICE_END = 1002,				// xmlService^OǂݏIۂCreateL֌WȂAΏۂ̃T[rXɑ郁bZ[W
		EM_CORE_CREATE_SERVICE_END = 1003,			// xmlService^OǂݏIۂCreatêݑΏۂ̃T[rXɑ郁bZ[W
		EM_TAG_DEFAULT_VALUE_SET = 1004,			// ^ÕftHgl[hw߃bZ[W
		EM_TAG_DEFAULT_VALUE_SET_END = 1005,		// ^ÕftHgl[hIbZ[W
		EM_WRAPONLY_UPDATE_TAGTRIGREF = 2000,		// Wrapp TagTrigger ListXV
		EM_DEBUG_WRITE_SERVICEOBJ = 9000			// Odebugo͂郁bZ[W
	};

#define	EG_MSG_USER 20000	//[U[bZ[Wp Jnԍ
#define EG_FALSE	0		// false, U
#define EG_TRUE		1		// true,  ^

//------------------------------------------------------------------------------
// XbhPriority`(Windowsp) lႢvCIeB
//  egapiWrap/EGDEFINE.csčXVĂB
//------------------------------------------------------------------------------
#define EG_PRIORITY_240_255 240	// Base priority(Win) = 1
#define EG_PRIORITY_232_239 232	// Base priority(Win) = 2
#define EG_PRIORITY_224_231 224	// Base priority(Win) = 3
#define EG_PRIORITY_216_223 216	// Base priority(Win) = 4
#define EG_PRIORITY_208_215 208	// Base priority(Win) = 5
#define EG_PRIORITY_200_207 200	// Base priority(Win) = 6
#define EG_PRIORITY_192_199 192	// Base priority(Win) = 7
#define EG_PRIORITY_184_191 184	// Base priority(Win) = 8
#define EG_PRIORITY_176_183 176	// Base priority(Win) = 9
#define EG_PRIORITY_168_175 168	// Base priority(Win) = 10
#define EG_PRIORITY_160_167 160	// Base priority(Win) = 11
#define EG_PRIORITY_152_159 152	// Base priority(Win) = 12
#define EG_PRIORITY_144_151 144	// Base priority(Win) = 13
#define EG_PRIORITY_136_143 136	// Base priority(Win) = 14
#define EG_PRIORITY_128_135 128	// Base priority(Win) = 15
#define EG_PRIORITY_80_127 80	// Base priority(Win) = 16
#define EG_PRIORITY_72_79 72	// Base priority(Win) = 22
#define EG_PRIORITY_64_71 64	// Base priority(Win) = 23
#define EG_PRIORITY_56_63 56	// Base priority(Win) = 24
#define EG_PRIORITY_48_55 48	// Base priority(Win) = 25
#define EG_PRIORITY_8_47 8		// Base priority(Win) = 26
#define EG_PRIORITY_0_7 0		// Base priority(Win) = 31


//------------------------------------------------------------------------------
// Oo͗p`
//------------------------------------------------------------------------------
#define EG_LOG_MSG "MSG"	// bZ[Wnh
#define EG_LOG_OPE "OPE"	// Iy[V
#define EG_LOG_WRN "WRN"	// [jO
#define EG_LOG_ERR "ERR"	// G[
#define EG_LOG_DBG "DBG"	// fobO
#define EG_LOG_FER "FER"	// FATAL ERROR

//
// ̑
//
#define EG_WAIT_FOREVER 0xFFFFFFFF	// = WAIT_FOREVER (Winłɖ̂)
//------------------------------------------------------------------------------
// EdgeVXeXybN`
//
//  egapiWrap/EGDEFINE.csčXVĂB
//	20200514_EgApiXybN\.xlsxčXVĂ	
//------------------------------------------------------------------------------
#define EG_MAX_TAGENTRY				10000	// ^OGgő吔ie[ũCfbNXj(ftHg)
#define EG_MAX_TAGNAME			48		// ^Oő咷
#define	EG_MAX_TAGCOMMENT		48		// ^ORgő咷
#define	EG_MAX_TAGADDRESS		512		// ^OAhXő咷
#define EG_MIN_TAGBITNO			0		// ^OAhXŏrbgwl
#define EG_MAX_TAGBITNO			7		// ^OAhXőrbgwl
#define EG_MAX_TAGADDRCATEGORY	10		// ^OAhX(EdgeIO|[g)̃JeSő吔
#define EG_MIN_TAGSTRINGLEN		1		// ^Oŏ
#define EG_MAX_TAGSTRINGLEN		84		// ^Oő咷
#define EG_MAX_TAGDATASIZE		128		// ^Of[^TCY

#define EG_MAX_DSETENTRY		512		// f[^ZbgGgő吔ie[ũCfbNXjftHgl(t@CD)
#define	EG_MAX_DSETNAME			32		// f[^Zbgő咷
#define	EG_MAX_DSETLINK			2048	// f[^ZbgɃNł^Oő吔 ftHgl(t@CD)

#define EG_MAX_CLCTENTRY		64		// RN^Ggő吔ie[ũCfbNXj ftHgl(t@CD)
#define	EG_MAX_CLCTNAME			8		// RN^ő咷 = Mailboxő咷

#define EG_MAX_SERVICEENTRY		32		// T[rXGgő吔i肵ĂȂj ftHgl(t@CD)
#define EG_MAX_SERVICENAME		24		// T[rXő咷
#define EG_MAX_SERVICEMAILBOXNAME	4		// T[rX[{bNX NameSpace Indexwl4byte
#define EG_MAX_SERVICEPATH		260		// T[rXpXő咷
#define EG_MAX_NODENAME			64		// m[hő咷

#define EG_MAX_SPACEENTRY		32		// l[Xy[XGgő吔
#define	EG_MAX_SPACENAME		16		// l[Xy[Xő咷

#define EG_MAX_MAILBOXENTRY		64		// [{bNXGgő吔 ftHgl(t@CD)
#define EG_MAX_MAILBOXNAME		8		// [{bNX(8byte)

#define EGFW_MAX_CLCTENTRY		16		// t[[N̈RN^ő吔 ftHgl(t@CD)
#define EGFW_MAX_MAILBOXENTRY	16		// t[[N̈[{bNXő吔 ftHgl(t@CD)
#define EGFW_MAX_TAGREFENTRY	1024	// t[[N̈TagRefGgő吔 ftHgl(t@CD)

#define EGFW_MAX_C2C_MAILBOXCOL	131072	// ReiԒʐM[{bNX1R[hőf[^ ftHgl(t@CD)
#define EGFW_MAX_C2C_MAILBOXROW	4096	// ReiԒʐM[{bNXő僌R[h ftHgl(t@CD)

#define	EG_MAX_TAGPTR_NUM		256				// ^O|C^ő吔(t@CD)
#define	EG_MAX_TAGPTR_SIZE		(1024 * 1024)	// ^O|C^Ńf[^TCY(t@CD)
#define	EG_MAX_TAGPTR_RETRY		3				// ^O|C^bN݂(t@CD)

#define EG_MAX_CATALOGNAME		12		// J^O(12byte)
#define EG_DIFF_VALUE_SIZE		8       // lrpf[^TCY
#define EG_MAX_PATH				260

#define EGFW_MAX_TAGTRIGENTRY	128		// t[[N̈TagTriggerGgő吔 ftHgl(t@CD) 32ȉł邱

#define EG_SHM_MAX_NODENAME		64		// Lo^m[hőTCY(oCg)
#define EG_SHM_MAX_PROCNAME		12		// Lo^vZXőTCY(oCg)
#define EG_SHM_MAX_OBJENAME		12		// Lo^IuWFNgőTCY(oCg)
#define EG_SHM_MAX_RETRY_LOCK	3		// bNgC

#define EG_SHM_KEYWORD			"MAP"
#define EG_SHM_DELIMITER		"/"
#define EG_SHM_KEY_DELI			EG_SHM_KEYWORD EG_SHM_DELIMITER
#define EG_SHM_IN_USE			1

#define EG_FIFO_MAX_RETRY_LOCK	3		// bNgC

#define EGFW_MAX_MESSAGEENTRY	16		// t[[N̈XMLŒ`\ȃbZ[Wő吔
#define EG_MAX_MESSAGENAME		48		// bZ[W(48byte) XMLŎw莞̂ݎgp
#define EG_MAX_MESSAGEARGS		260		// bZ[W XMLŎw莞̂ݎgp
#define EG_MESSFIFOTAG_RECORDSIZE 1024	// bZ[WAPIŎgpFIFO^ÔPR[hTCY	
#define EG_MESSFIFOTAG_RECORDCOUNT 32	// bZ[WAPIŎgpFIFO^ÕR[h			

#pragma pack(push,1)
//------------------------------------------------------------------------------
// Lێp\
//------------------------------------------------------------------------------
/// <summary>
/// Lێp\
/// </summary>
	typedef struct tSHM_DESC {
		char		chSourceUpper[255];			// ^OAhX255܂
		char		chNull;						// NULL (ȍ~̃f[^jh~)
		uint8_t		InUse;						// 0:gpA1:gp
		uint8_t		BitUse;						// BitItZbg̎gpL
		uint16_t	BitOffset;					// BitItZbgl
		uint32_t	Offset;						// L擪̃ItZbgl(BYTEP)
		uint32_t	MapSize;					// L̂̂̃TCY(BYTEP)
		uint32_t	Hash;						// ʯl̷
		char		NodeName[((EG_SHM_MAX_NODENAME + 1 + 3) & ~3)];	// LJ^OĂm[h  (64 + NULL)
		char		ProcName[((EG_SHM_MAX_PROCNAME + 1 + 3) & ~3)];	// LJ^OĂvZX(12 + NULL)
		char		ObjeName[((EG_SHM_MAX_OBJENAME + 1 + 3) & ~3)];	// J^OĂ鋤L(12 + NULL)
	} SHM_DESC;
	#define EG_SHM_DESC_SIZE	sizeof(SHM_DESC)	// 372 byte
#pragma pack(pop)

#pragma pack(push,1)
//------------------------------------------------------------------------------
// EgTagIuWFNg`
//------------------------------------------------------------------------------
/// <summary>
/// EgTAGIuWFNgGg[\
/// </summary>
	typedef struct tTagsDesc
	{
		bool		force;								// ReadOnly(Truȅꍇ͏ݕs)
		bool		isLink;								// N^OtO
		uint8_t		cnt;								// ^OݎɒlωꍇJEgグ
		EGVAR		var;
		char		chName[EG_MAX_TAGNAME + 1];			// ^O
		char		chComment[EG_MAX_TAGCOMMENT + 1];	// ^ORg
		union {
			char		chSource[EG_MAX_TAGADDRESS + 1];	// ^OAhX
			SHM_DESC	SHM;								// Lێp\
		};

		/* ߕ ŗLèر */
		union {

			/* FIFO ŗLر */
			struct {
				uint16_t	record_count;					// FIFOޯ̧̈̑ںސ(@memo ںޒvar.sizeŊǗĂB)
				bool		block_overrun;					// @todo
			} fifo;

		} extData;

	} TagsDesc, *LPTagsDesc;
#pragma pack(pop)


//------------------------------------------------------------------------------
// \̒`
//------------------------------------------------------------------------------
typedef	 int32_t(*FUNC_POINTER)(const char *, int32_t, void*);						// bZ[Wnhp R[obN֐ TCYŒ(2048)
typedef	 int32_t(*FUNC_POINTEREX)(const char *, int32_t, void*, int32_t);			// bZ[Wnhp R[obN֐ TCY
#pragma pack(push,1)
	//
	// RT-edge system eIuWFNgf[^TCYݒl (t@Cǂݍݒl)
	//
	typedef struct tEdgeSystemConfig
	{
		uint32_t			MaxDsetEntry;		// f[^ZbgGgő吔ie[ũCfbNXj
		uint32_t			MaxDsetLink;		// f[^Zbg f[^N^Oő吔(TagRef)
		uint32_t			MaxClctEntry;		// RN^ Ggő吔
		uint32_t			MaxServiceEntry;	// T[rXRei Ggő吔
		uint32_t			MaxMailboxEntry;	// [{bNX Ggő吔
		uint32_t			MaxC2CMailboxCol;	// RT-edget[[N ReiԒʐM[{bNXőf[^TCY(ColSize) 
		uint32_t			MaxC2CMailboxRow;	// RT-edget[[N ReiԒʐM[{bNX őێ(RowSize)
		uint32_t			MaxFwClctEntry;		// RT-edget[[N  RN^IuWFNgQ Ggő吔
		uint32_t			MaxFwMailboxEntry;	// RT-edget[[N [{bNXIuWFNg Ggő吔
		uint32_t			MaxFwTagRefEntry;	// RT-edget[[N TagRefIuWFNg Ggő吔
		uint32_t			MaxTagPtrNum;		// ^O|C^ő吔
		uint32_t			MaxTagPtrSize;		// ^O|C^őf[^TCY(oCgP)
		uint32_t			MaxTagPtrRetry;		// ^O|C^bN݂
		uint32_t			MaxFwTagTrigEntry;	// RT-edget[[N TagTriggerő吔
		uint32_t			MaxFwMessageEntry; // RT-edget[[N Message Ggő吔

	}EDGESYSTEMCONFIG, *LPEDGESYSTEMCONFIG;
	//
	// RT-edge system ݒ
	//
	typedef struct tEdgeConfig
	{
		uint8_t				bDebug;		// fobOtO
		uint8_t				bReadXmlF;	// xmlǂނǂ܂Ȃ̃tO 0:ǂ܂Ȃ, 1:ǂ (Corep)@ftHg 1:ǂ 
		uint16_t			shPriority; // [{bNXXbh@vCIeB (65535=ftHg̗pw:150)
		FUNC_POINTER		fpUserMessHdlFunc;		//[U[bZ[Wnh TCYŒ
		char				Path[EG_MAX_SERVICEPATH+1];	// T[rXvZX/DLLt@CpX(ŃT[rXExml̃pXɕϊ邽߂Ɏgp)
		char				_nil00;
		uint8_t				_reserve1[2];
		FUNC_POINTEREX		fpUserMessHdlFuncEx;	//[U[bZ[Wnh TCY
	}EDGECONFIG ,*LPEDGECONFIG;
	#define EDGE_CONFIG_DEFAULT {0, 1, 65535, 0, 0}

	//
	// RT-edge ServiceCreateݒ
	//
	typedef struct tEdgeServiceConfig
	{
		char			NodeName[EG_MAX_NODENAME + 1];	// T[rX̋Nm[h
		uint16_t		Class;							// T[rXNX
	}EDGESERVICECONFIG, *LPEDGESERVICECONFIG;
	#define EDGE_SERVICECONFIG_DEFAULT { 0 }


#pragma pack(pop)

//
// For Framework
//
#pragma pack(push,1)
	//------------------------------------------------------------------------------
	// TagRef IuWFNg
	//------------------------------------------------------------------------------
	typedef struct
	{
		char		Name[EG_MAX_TAGNAME+1];			// EgTag
		char		Address[EG_MAX_TAGADDRESS+1];	// AhX(\[X)
		uint16_t	Type;							// f[^^
		uint16_t	Size;							// f[^TCY
		void*		Entry;							// EgTagEntry|C^
		BYTE		_byOldVal[EG_DIFF_VALUE_SIZE];	// IɔrpɎgp gŒlKv(ł͕ύXȂ)
	} EGTAGREF;

	//------------------------------------------------------------------------------
	//RN^̃ACȅ
	//------------------------------------------------------------------------------
	typedef struct
	{
		char		CollectorName[EG_MAX_CLCTNAME+1];	// RN^
		char		DatasetName[EG_MAX_DSETNAME+1];		// f[^Zbg
	} EGCOLLECTORITEMINFO;
	//------------------------------------------------------------------------------
	// CollectorIuWFNg
	//------------------------------------------------------------------------------
	typedef struct
	{
		char		CollectorName[EG_MAX_CLCTNAME+1];		// RN^
		char		OwnerServiceName[EG_MAX_SERVICENAME+1];	// RN^sT[rX
		char		DatasetName[EG_MAX_DSETNAME+1];			// f[^Zbg
		uint32_t	dwInterVal;								// W(ms)
		uint8_t		byPriority;								// XbhvCIeB
		uint32_t	dwStackSize;							// X^bNTCY(Œ)
		uint32_t	dwColSize;								// i[1R[h̃TCY(ftHg2048)
		uint32_t	dwRowSize;								// i[
		void*		hHandle;								// Xbhnh
		uint8_t		bWorkingF;								// FALSE:~ , TRUE:쒆
		uint8_t		bCancelF;								// TRUE:~tO
	} EGLOCALCOLLECTOR;
	//------------------------------------------------------------------------------
	// CollectorRefIuWFNg
	//------------------------------------------------------------------------------
	typedef struct
	{
		char		CollectorName[EG_MAX_CLCTNAME+1];		// RN^
		char		DatasetName[EG_MAX_DSETNAME+1];			// f[^Zbg
		uint32_t	dwColSize;								//i[1R[h̃TCY(ftHg2048)
		uint32_t	dwRowSize;								//i[
	} EGCOLLECTORREF;
	//------------------------------------------------------------------------------
	// MailBox\
	//------------------------------------------------------------------------------
	typedef struct
	{
		char		MailBoxName[EG_MAX_MAILBOXNAME+1];		// [{bNX
		uint32_t	dwColSize;								// 1R[h
		uint32_t	dwRowSize;								// R[h
	} EGMAILBOXINFO;

	//------------------------------------------------------------------------------
	// MailBox\
	//------------------------------------------------------------------------------
	typedef struct
	{
		char		MailBoxName[EG_MAX_MAILBOXNAME+1];		// [{bNX
		uint32_t	dwColSize;								// 1R[h
		uint32_t	dwRowSize;								// R[h
		RTCDMEMINFO MemInfo;								// RTCD̍\ (RTCDMEMINFO)
	} EGMAILBOX;
	//------------------------------------------------------------------------------
	// Edge I/O|[g
	//------------------------------------------------------------------------------
	typedef struct
	{
		void*		Entry;									// EgTagEntry|C^
		char		SrcAddr[EG_MAX_TAGADDRESS + 1];			// AhX
		char		AddrName[EG_MAX_CATALOGNAME + 1];		// AhX(́F疼)
		int32_t		Index;									// \[gOCfbNXl 0`
		uint32_t	Offset;									// AhX̃ItZbgAhX
		uint8_t		byBitUse;								// rbggptO
		uint16_t	woBitPos;								// rbgʒu ő2byte (0x0`0xF)
		uint16_t	woMaxBit;								// őrbg gpɑSĂEGIOPORTאݒ 
		uint8_t		bIsValied;								// LI/O|[g̏ꍇ1 ̏ꍇ0
	} EGIOPORT;
	//------------------------------------------------------------------------------
	// TagTrigger T[rXReiŎf[^
	//------------------------------------------------------------------------------
	typedef struct
	{
		char		Name[EG_MAX_TAGNAME + 1];		// ^O
		char		Address[EG_MAX_TAGADDRESS + 1];	// AhX(\[X)
		void*		Entry;							// EgTagEntry|C^
		uint16_t	Type;							// f[^^
		uint16_t	Size;							// f[^TCY
		BYTE		Count;							// ȑÕJE^[
	} EGTAGTRIGGER, *LPEGTAGTRIGGER;
	//------------------------------------------------------------------------------
	// TagTrigger Xbhԃf[^󂯓np@1Tag
	//------------------------------------------------------------------------------
	typedef struct
	{
		uint16_t	arrNo;								// [Joϐ zNo
		// ^Ol gK[MReadēn
		union {
			union EgTrigValues
			{
				bool		boolVal;
				float		fltVal;
				double		dblVal;
				char		cVal;
				int16_t		iVal;
				int32_t		lVal;
				int32_t		intVal;
				int64_t		llVal;
				uint8_t		bVal;
				uint16_t	uiVal;
				uint32_t	ulVal;
				uint32_t	uintVal;
				uint64_t	ullVal;
			};
			intptr_t	val;
		};
	} EGTAGTRIGINFO, *LPEGTAGTRIGINFO;
	//------------------------------------------------------------------------------
	// TagTrigger Xbhԃf[^󂯓np 1bZ[W
	//------------------------------------------------------------------------------
	typedef struct
	{
		uint16_t TblCount;								// e[u̔z
		EGTAGTRIGINFO pTblTagTriggers[1];				// ^OgK[\̃e[u
	} EGTAGTRIGINFOS, *LPEGTAGTRIGINFOS;
	//------------------------------------------------------------------------------
	// Message\
	//------------------------------------------------------------------------------
	typedef struct
	{
		char		Name[EG_MAX_MESSAGENAME + 1];		// bZ[W
		uint32_t	No;									// bZ[WNo
		char		DestName[EG_MAX_SERVICENAME + 1];	// MT[rX
		BYTE		ExecTiming;							// s^C~O@0:C(gŎ) , 1:InitializeI
		BYTE		Timer;								// ExecTiming1̎A֐Ăяos^C~Osec(b)Ŏw
														// F0̏ꍇ͎s֐Ăяos
														//     1̏ꍇ͎s֐Ăяo1secɎ{
		BYTE		ArgType;							// ArgsType(ϊɕKv) Tag̃^Cvƈꏏ
		uint32_t	Size;								// ArgsŎw肵TCY(xmlł̎w͕s)
		BYTE		Args[EG_MAX_MESSAGEARGS + 1];		// (xmlł̎w͕s)
	} EGMESSAGEOBJ;
#pragma pack(pop)
//------------------------------------------------------------------------------
// RT-edge API`
//------------------------------------------------------------------------------

	//
	// System֘A
	//
	edge_API int32_t EgInit(EDGECONFIG *Config);	// CjVCYs֐
	edge_API int32_t EgFinalize();					// t@CiCYs֐
	edge_API int32_t EgSetRTCD(const char *Name);	// RTCD
	edge_API int32_t _EgSysDefSetting(EDGESYSTEMCONFIG* SysCfg);	// RT-edge object TCYݒ
	edge_API bool _EgSysTagCreate();				// VXepTAG쐬
	//
	// Decoder֘A
	//
	edge_API int32_t EgDecode(void* dst, size_t dstsize, const void* src, size_t srcsize, const char* addrformat, size_t *actualsize);	// address formatɑăf[^o
	edge_API int32_t EgEncode(void* dst, size_t dstsize, const void* src, size_t srcsize, const char* addrformat, size_t *actualsize);	// address formatɑăf[^o
	edge_API const char* EgMakeAddress(int32_t offset, size_t size, char* buff, size_t buffsize);					// ItZbgETCYaddress format쐬
	edge_API int32_t EgParseAddress(const char* addrformat, int32_t *offset, size_t *size, int16_t *bit, uint8_t *typemode);	// address formatItZbgETCYɕ

	//
	// Tag֘A
	//
	edge_API int32_t EgTagInit(uint32_t NumMax);	// EgTagil[Xy[Xj
	edge_API int32_t EgTagInitConfig(void);
	edge_API int32_t EgTagCreate(const char *Name, uint16_t Type, uint16_t Size, const char *Source, const char *Comment);	// EgTag̍쐬
	edge_API int32_t EgTagCreateEx(const char *Name, uint16_t Type, const char *Source, const char *Comment);	// EgTag̍쐬iTCYwȂŁj
	edge_API int32_t EgTagCreateSp(const char *Name, uint16_t Type, const char *Source, const char *Comment, char *regName, uint16_t regNameSize, uint16_t *isLink);	// EgTag̍쐬i^OdΉŁj
	edge_API int32_t EgTagWrite(const char *Name, void *pBuffer, uint16_t wSize);	// EgTag̒l
	edge_API int32_t EgTagWriteByIndex(EDGE_INDEX *index, void *pBuffer, uint16_t wSize);	// EgTag̒l(INDEXw)
	edge_API int32_t EgTagWriteByEntry(void *pEntry, void *pBuffer, uint16_t wSize);		// EgTag̒l(Entryw)
	edge_API int32_t EgTagRead(const char *Name, void* byteArray, uint16_t wSize);	// EgTag̒lǂݍ
	edge_API int32_t EgTagReadByIndex(EDGE_INDEX *index, void* byteArray, uint16_t wSize);	// EgTag̒lǍ(INDEXw)
	edge_API int32_t EgTagReadByEntry(void *pEntry, void* byteArray, uint16_t wSize);		// EgTag̒lǍ(Entryw)
	edge_API int32_t EgTagGetProperty(const char *Name, const char *propName, void* Value, int32_t dwSize);	// EgTagProperty(Size, Type, Sourceǂݍ)
	edge_API int32_t EgTagGetPropertyByIndex(EDGE_INDEX *index, const char *propName, void* Value, int32_t dwSize);	// EgTagProperty(Size, Type, Sourceǂݍ)(INDEXw)
	edge_API int32_t EgTagGetPropertyByEntry(void *pEntry, const char *propName, void* Value, int32_t dwSize);	// EgTagProperty(Size, Type, Sourceǂݍ)(Entryw)
	edge_API void * EgTagGetHandle(void);									// nhl擾
	edge_API int32_t EgTagWriteVar(const char *Name, EGVAR val);			// Variant
	edge_API EGVAR EgTagReadVar(const char *Name);							// Variantǂݍ
	edge_API int32_t EgTagGetCount(uint32_t *itemNum);						// ݂EgTago^擾
	edge_API int32_t EgTagGetEnum(EDGE_INDEX *pBuffer, uint32_t dwSize, uint32_t *itemNum);	// EgTag̃CfbNXꗗ擾
	edge_API int32_t EgTagInitSegment();
	edge_API int32_t EgTagReadSegment(const char *Name, uint16_t wOffset, void* byteArray, uint16_t wSize);
	edge_API int32_t EgTagWriteSegment(const char *Name, uint16_t wOffset, void *pBuffer, uint16_t wSize);
	edge_API int32_t EgTagIsAliveSegment(const char *Name);
	edge_API int32_t EgTagCreateSegment(const char *Name, uint16_t Type, uint16_t Size, const char *Source, const char *Comment, char *regName, uint16_t regNameSize, uint16_t *isLink);
	edge_API int32_t EgTagReadString(const char *Name, char* pString, uint16_t wSize);
	edge_API int32_t EgTagWriteString(const char *Name, char *pString);
	edge_API int32_t EgTagReadSegmentByIndex(EDGE_INDEX *index, uint16_t wOffset, void* byteArray, uint16_t wSize);	// EgTag̒lǍ(INDEXw)
	edge_API int32_t EgTagWriteSegmentByIndex(EDGE_INDEX *index, uint16_t wOffset, void *pBuffer, uint16_t wSize);	// EgTag̒l(INDEXw)
	edge_API int32_t EgTagReadSegmentByEntry(void *pEntry, uint16_t wOffset, void* byteArray, uint16_t wSize);		// EgTag̒lǍ(Entryw)
	edge_API int32_t EgTagWriteSegmentByEntry(void *pEntry, uint16_t wOffset, void *pBuffer, uint16_t wSize);		// EgTag̒l(Entryw)
	edge_API int32_t EgTagSetDefaultValue();	// ^OlZbg
	edge_API int32_t EgTagSetDefaultValueByGroup(uint16_t wGroup);	// ^OlZbg

	edge_API int32_t EgTagCreateFIFO(const char *Name, uint16_t RecordSize, uint16_t RecordCount, bool Reserved1_LetFalse, const char *Comment, char *regName, uint16_t regNameSize, uint16_t *isLink);
	edge_API int32_t EgTagDequeueFIFOByEntry(void *pEntry, void* byteArray, uint16_t wSize, uint16_t *wRemain);
	edge_API int32_t EgTagDequeueFIFOByIndex(EDGE_INDEX *index, void* byteArray, uint16_t wSize, uint16_t *wRemain);
	edge_API int32_t EgTagDequeueFIFO(const char *Name, void* byteArray, uint16_t wSize, uint16_t *wRemain);
	edge_API int32_t EgTagEnqueueFIFOByEntry(void *pEntry, void* byteArray, uint16_t wSize, uint16_t *wRemain);
	edge_API int32_t EgTagEnqueueFIFOByIndex(EDGE_INDEX *index, void* byteArray, uint16_t wSize, uint16_t *wRemain);
	edge_API int32_t EgTagEnqueueFIFO(const char *Name, void* byteArray, uint16_t wSize, uint16_t *wRemain);
	edge_API int32_t EgTagEnqueueRingFIFOByEntry(void *pEntry, void* byteArray, uint16_t wSize, uint16_t *wRemain);
	edge_API int32_t EgTagEnqueueRingFIFOByIndex(EDGE_INDEX *index, void* byteArray, uint16_t wSize, uint16_t *wRemain);
	edge_API int32_t EgTagEnqueueRingFIFO(const char *Name, void* byteArray, uint16_t wSize, uint16_t *wRemain);
	edge_API int32_t EgTagGetRemainFIFOByEntry(void *pEntry, uint16_t *wRemain);
	edge_API int32_t EgTagGetRemainFIFOByIndex(EDGE_INDEX *index, uint16_t *wRemain);
	edge_API int32_t EgTagGetRemainFIFO(const char *Name, uint16_t *wRemain);
	edge_API int32_t EgTagClearFIFOByEntry(void *pEntry);
	edge_API int32_t EgTagClearFIFOByIndex(EDGE_INDEX *index);
	edge_API int32_t EgTagClearFIFO(const char *Name);

	//
	// EgValiant (EGVAR)^ϐ
	//
	edge_API int32_t EgTagWriteVar(const char *Name, EGVAR val);			// Variant 
	edge_API EGVAR EgTagReadVar(const char *Name);							// Variantǂݍ
	edge_API int32_t EgVariantInit(EGVAR *pvarg);							// Variantf[^
	edge_API int32_t EgVariantCopy(EGVAR *pvargDest, const EGVAR *pvargSrc);// Variantf[^Rs[
	edge_API EGVAR EgAllocateString(const char* string);					// σ쐬

	//
	// Mailbox֘A
	//

	edge_API int32_t EgMailboxCreateEx(const char *pName, uint32_t dwColSize, uint32_t dwRowSize, RTCDMEMINFO *pRtcdInfo);	// EgMailbox쐬
	edge_API int32_t EgMailboxDelete(RTCDMEMINFO *pRtcdInfo);																// EgMailbox폜
	edge_API int32_t EgMailboxOpen(const char *pName, uint32_t dwAccess, RTCDHANDLE *pHandle);								// EgMailboxI[v
	edge_API int32_t EgMailboxClose(RTCDHANDLE *pHandle);																	// EgMailboxN[Y
	edge_API int32_t EgMailboxSend(RTCDHANDLE *pHandle, const char *SenderName, int32_t MessageNo, void* pData, uint32_t dwSize);	// EgMailboxփf[^EbZ[WM
	edge_API int32_t EgMailboxReceive(RTCDHANDLE *pHandle, char *SenderName, uint32_t dwNameSize, int32_t* MessageNo, void* pData, uint32_t dwSize, uint32_t dwTimeOut);// EgMailboxf[^EbZ[WM
	edge_API int32_t EgMailboxGetInfo(RTCDHANDLE *pHandle, EDGE_RTCD_HEADER *pInfo);										// EgMailbox擾
	edge_API void * EgMailboxGetHandle(void);																				// EgMailbox̃nhl擾
	edge_API int32_t EgMailboxGetProperty(const char *Name, const char *propName, void* Value, int32_t dwSize);				// EgMailboxProperty擾 
	edge_API int32_t EgMailboxGetPropertyByIndex(EDGE_INDEX *pBuffer, const char *propName, void* Value, int32_t dwSize);	// EgMailboxProperty擾(CfbNXw)
	edge_API int32_t EgMailboxGetCount(uint32_t *itemNum);																	// EgMailboxo^擾
	edge_API int32_t EgMailboxGetEnum(EDGE_INDEX *pBuffer, uint32_t dwSize, uint32_t *pItemNum);							// EgMailbox̃CfbNXꗗ擾
	edge_API int32_t EgMailboxOpenSC(const char *Name, uint32_t dwAccess, RTCDHANDLE *pHandle);					// EgMailboxI[v



	//
	// Dataset֘A
	//
	typedef struct tdslink					// DSet̃T[`p
	{
		char* TagName;	// ^O
		void* tag;		// TagDesc*
		void* ds;		// DsetDesc*
		uint16_t inst;	// FindFirst/Next
		uint16_t offset; // f[^Zbgɓo^ĂTag̃f[^TCYʒu
	}dslink;
	edge_API int32_t EgDatasetCreate(const char *Name);										// Dataset쐬
	edge_API int32_t EgDatasetAddTag(const char *Name, const char *TagName);				// DatasetEgTagǉ
	edge_API void * EgDatasetGetHandle(void);												// Dataset̃nhl擾
	edge_API size_t EgDatasetGetSize(const char *Name);										// Dataset̑f[^TCY擾
	edge_API int32_t EgDatasetGetFirst(const char *Name, dslink *dslink);					// Dataset̍ŏEgTagւ̃N擾
	edge_API int32_t EgDatasetGetNext(dslink *dslink);										// Dataset̎EgTagւ̃N擾
	edge_API int32_t EgDatasetGetBinary(const char *Name, void* Dest, size_t DestSize);		// Dataset̑f[^l(oCi)擾
	edge_API int32_t EgDatasetSetBinary(const char *Name, void* Source, size_t SourceSize);	// DatasetTagɎw肵oCil𕪉Đݒ
	edge_API int32_t EgDatasetGetPropertyByIndex(EDGE_INDEX *pBuffer, const char *propName, void* Value, int32_t dwSize);	// DatasetProperty擾(CfbNXw)
	edge_API int32_t EgDatasetGetCount(uint32_t *itemNum);									// Dataseto^擾
	edge_API int32_t EgDatasetGetEnum(EDGE_INDEX *pBuffer, uint32_t dwSize, uint32_t *pItemNum);	// Dataset̃CfbNXꗗ擾


	//
	// Collector֘A
	//
	edge_API int32_t EgCollectorCreate(const char *Name, const char *OwnerName, uint32_t Interval, uint8_t Priority, uint32_t ColSize, uint32_t RowSize, const char *DSetName);	// RN^̍쐬
	edge_API int32_t EgCollectorGetProperty(const char *Name, const char *propName, void* Value, int32_t dwSize);	// RN^Property擾 
	edge_API int32_t EgCollectorGetPropertyByIndex(EDGE_INDEX *pBuffer, const char *propName, void* Value, int32_t dwSize);	// RN^Property擾(CfbNXw)
	edge_API void * EgCollectorGetHandle(void);	//@RN^̃nh擾
	edge_API int32_t EgCollectorGetCount(uint32_t *itemNum);										// RN^o^擾
	edge_API int32_t EgCollectorGetEnum(EDGE_INDEX *Buffer, uint32_t dwSize, uint32_t *pItemNum);	// RN^̃CfbNXꗗ擾


	//
	// Service֘A
	//
	typedef intptr_t	EGSERVICEHANDLE;	// T[rX̃nh
	edge_API void * EgServiceGetHandle(void);									// nhl擾
	edge_API int32_t EgServiceCreate(const char *Name, const char *path, const char *arg, EGSERVICEHANDLE *pid); // T[rX̍쐬
	edge_API int32_t EgServiceCreateEx(const char *Name, const char *path, const char *arg, EGSERVICEHANDLE *pid, EDGESERVICECONFIG *config); // [gT[rX̍쐬
	edge_API int32_t EgServiceGetCount(uint32_t *itemNum);										// T[rXo^擾
	edge_API int32_t EgServiceGetEnum(EDGE_INDEX *pBuffer, uint32_t dwSize, uint32_t *itemNum);	// T[rX̃CfbNXꗗ擾
	edge_API int32_t EgServiceGetProperty(const char *Name, const char *propName, void* Value, int32_t dwSize);	// T[rXProperty擾 
	edge_API int32_t EgServiceGetPropertyByIndex(EDGE_INDEX *pBuffer, const char *propName, void* Value, int32_t dwSize);	// T[rXProperty擾(CfbNXw)

	//
	// Framework
	//


	typedef  void(*INITENDFUNC_POINTER)();							// Ip R[obN֐
	typedef  void(*DEBUGFUNC_POINTER)();							// fobOo͗p R[obN֐

	edge_API int32_t _EgFW_Initialize(EDGECONFIG *Config);			//
	edge_API int32_t _EgFW_Finalize();								//ŏI
	edge_API int32_t EgFW_AddInitEndFunc(INITENDFUNC_POINTER p);	//IɌĂԊ֐ ǉ
	edge_API int32_t EgFW_AddDebugFunc(DEBUGFUNC_POINTER p);		//fobOp֐ǉ
	edge_API void EgFW_PrintLog(const char* pServiceName, const char* pMode, const char* format, ...);		// Oo͗p֐
	edge_API void _EgFW_PrintSysLog(const char* pServiceName, const char* pMode, const char* format, ...);	// Oo͗p(VXep)֐
	edge_API int32_t EgFW_AddTagTrigger(const char* pTagName);		// ^OgK[o^p֐
	edge_API int32_t EgFW_SendMessageAsync(const char* ServiceName, int32_t messageNo, void* arg, uint32_t dwSize);		// bZ[W񓯊M֐

	edge_API int32_t _EgFW_GetServiceName(char* pName);				// T[rX(nbVl)̎擾
	edge_API int32_t _EgFW_GetServiceRealName(char* pName);			// T[rX̎擾
	edge_API int32_t _EgFW_GetServiceStateName(char* pName);		// T[rXXe[^X̎擾
	edge_API int32_t _EgFW_GetEgTagRef_OUT_Count();					// EgTagRef_OUT̐擾
	edge_API int32_t _EgFW_GetEgTagRef_IN_Count();					// EgTagRef_IN̐擾
	edge_API int32_t _EgFW_GetEgTagRef_Count();						// EgTagRef̐擾
	edge_API int32_t _EgFW_GetCollectorRef_Count();					// EgCollectorRef̐擾
	edge_API int32_t _EgFW_GetMailbox_Count();						// EgMailbox擾
	edge_API int32_t _EgFW_GetTagTrigger_Count();					// TagTrigger̐擾
	edge_API int32_t _EgFW_GetTagRef_OUT(EGTAGREF* tagref, int32_t index);	// EgTagRef_OUT擾
	edge_API int32_t _EgFW_GetTagRef_IN(EGTAGREF* tagref, int32_t index);	// EgTagRef_IN擾
	edge_API int32_t _EgFW_GetTagRef(EGTAGREF* tagref, int32_t index);		// EgTagRef擾
	edge_API int32_t _EgFW_GetEgTagRef_OUT_PortInfo_Count();						// EgTagRef_OUT_PortInfo̐擾
	edge_API int32_t _EgFW_GetEgTagRef_IN_PortInfo_Count();							// EgTagRef_IN_PortInfo̐擾
	edge_API int32_t _EgFW_GetEgTagRef_PortInfo_Count();							// EgTagRef_PortInfo̐擾
	edge_API int32_t _EgFW_GetTagRef_OUT_PortInfo(EGIOPORT* egio, int32_t index);	// EgTagRef_OUT_PortInfo擾
	edge_API int32_t _EgFW_GetTagRef_IN_PortInfo(EGIOPORT* egio, int32_t index);	// EgTagRef_IN_PortInfo擾
	edge_API int32_t _EgFW_GetTagRef_PortInfo(EGIOPORT* egio, int32_t index);		// EgTagRef_PortInfo擾
	edge_API int32_t _EgFW_GetCollector(EGLOCALCOLLECTOR* collector, int32_t index);		// EgCollecor擾
	edge_API int32_t _EgFW_GetCollectorRef(EGCOLLECTORREF* collectorRef, int32_t index);	// EgCollectorRef擾
	edge_API int32_t _EgFW_GetMailBox(EGMAILBOX* mailBoxe, int32_t index);					// EgMailbox擾
	edge_API int32_t _EgFW_GetTagTrigger_Count();											// EgTagTrigger̐擾
	edge_API int32_t _EgFW_GetTagTrigger(EGTAGTRIGGER* tagtrigger, int32_t index);			// EgTagTrigger擾
	edge_API int32_t _EgFW_GetMessageObj_Count();											// EgMessageObj̐擾
	edge_API int32_t _EgFW_GetMessageObj(EGMESSAGEOBJ* messageObj, int32_t index);			// EgMessageObj擾
	//
	// Framework Member
	//
	extern edge_API char ServiceRealName[EG_MAX_SERVICENAME +1];			//T[rX
	extern edge_API char ServiceName[EG_MAX_SERVICEMAILBOXNAME + 1];		//T[rXCfbNX
	extern edge_API char ServiceMailboxName[EG_MAX_SERVICEMAILBOXNAME + 1];	//T[rXCfbNX
	extern edge_API char ServiceStateName[EG_MAX_TAGNAME+1];				//T[rX̃ANeBuXe[^X(Tag)
	extern edge_API char ServiceStateErrName[EG_MAX_TAGNAME+1];				//T[rẌُԃXe[^X(Tag)
	extern edge_API char ServiceStateRunName[EG_MAX_TAGNAME+1];				//T[rX̎sԃXe[^X(Tag)
	extern edge_API char ServiceStateLiveName[EG_MAX_TAGNAME+1];			//T[rXsCNg(Tag)
	extern edge_API char ServiceMboxTagName[EG_MAX_TAGNAME + 1];			//T[rX[{bNX Tago^
	extern edge_API char ServiceMboxColSizeName[EG_MAX_TAGNAME + 1];		//T[rXԒʐM[{bNX1R[hTCY(Tag)
	extern edge_API char ServiceMboxRowSizeName[EG_MAX_TAGNAME + 1];		//T[rXԒʐM[{bNX̃R[h(Tag)
	extern edge_API int32_t egTagRefs_OUT_Count;							//TagRef OUT ̐
	extern edge_API int32_t egTagRefs_IN_Count;								//TagRef IN  ̐
	extern edge_API int32_t egTagRefs_Count;								//TagRef     ̐
	extern edge_API int32_t egCollectors_Count;								//Collector  ̐
	extern edge_API int32_t egCollectorRefs_Count;							//CollectorRef ̐
	extern edge_API int32_t egMailBoxes_Count;								//MailBox    ̐
	extern edge_API int32_t egTagTriggers_Count;							//TagTrigger ̐
	extern edge_API int32_t egMessages_Count;								//Message    ̐

	extern edge_API EGTAGREF* egTagRefs_OUT;								//TagRef OUT ꗗ |C^
	extern edge_API EGTAGREF* egTagRefs_IN;									//TagRef IN  ꗗ |C^
	extern edge_API EGTAGREF* egTagRefs;									//TagRef     ꗗ |C^
	extern edge_API EGIOPORT* egTagRefs_OUT_PortInfo;						//TagRef OUTge[u(EdgeIO|[g) ꗗ |C^
	extern edge_API EGIOPORT* egTagRefs_IN_PortInfo;						//TagRef IN ge[u(EdgeIO|[g) ꗗ |C^
	extern edge_API EGIOPORT* egTagRefs_PortInfo;							//TagRef    ge[u(EdgeIO|[g) ꗗ |C^
	extern edge_API EGLOCALCOLLECTOR* egCollectors;							//Collector  ꗗ |C^
	extern edge_API EGCOLLECTORREF* egCollectorRefs;						//CollectorRef ꗗ |C^
	extern edge_API EGMAILBOX* egMailBoxes;									//MailBox    ꗗ |C^
	extern edge_API EGTAGTRIGGER* egTagTriggers;							//TagTrigger ꗗ|C^
	extern edge_API EGMESSAGEOBJ* egMessageObjs;							//MessageObj ꗗ|C^

	//
	// etc
	//
	extern edge_API int32_t EgGetTime(EDGE_TIME_STAMP *pTime);				//Ԃ̎擾
	extern edge_API int32_t EgGetTimeVal(EDGE_TIME_VAL *pTime);				//Ԃ̎擾
	extern edge_API int32_t EgLocaltime64(void* pTime, void* pLongtime);	//Ԃ̕ϊ

#pragma pack(pop)

#ifdef __cplusplus
}
#endif
