////
/// Copyright(C) 2020 Micronet Co. All Rights Reserved.
//
/*------------------------------------------------------------------------------
Tv: RT-edge RTCD֘A@\API wb_[t@C
: {t@C͑SvWFNg(INtime/NTX/Win)Ŏgp鋤ʃt@CłB
: 2019.08.08 VK쐬
      2019.12.09 RTCDoߕb 32bit64bitɕύX
--------------------------------------------------------------------------------*/

#pragma once
#ifdef __INTIME__
	#include <sys/time.h>
	#include <rttypes.h>
#else
	#include <windows.h>
#endif

#ifdef __cplusplus
extern "C"
{
#endif

#ifdef __INTIME__	// INtimelCeBu
#ifdef  egRTCD_EXPORTS
#define egRTCD_API
#else
#define egRTCD_API __declspec(dllimport)
#endif
#else				// Windows
#ifdef _USE_NTX_	// INtimeL(NTXgp)
#ifdef egRTCDNtx_EXPORTS
#define egRTCD_API
#else
#define egRTCD_API __declspec(dllimport)
#endif  
#else				// INtime
#ifdef egRTCDWin_EXPORTS
#define egRTCD_API
#else
#define egRTCD_API __declspec(dllimport)
#endif  
#endif
#endif

// RTCDHANDLE type
typedef unsigned long long OBJHANDLE;

// RTCDm[hJ^O
static const char* EGRTCDNODE = "EGRTCDNODE";		// RTCDm[hpJ^O

//------------------------------------------------------------------------------
// G[R[h
//------------------------------------------------------------------------------
#define EDGE_SUCCESS							0x00000000	// I
#define EDGE_LOCATION_ERROR						0x80000001	// P[Vnh擾G[
#define EDGE_KERNEL_NOT_RUNNING					0x80000002	// J[lNĂ܂
#define EDGE_ROOTPROCESS_ERROR					0x80000003	// [gvZX擾G[
#define EDGE_PARAM_INVALID						0x80000004	// p[^sł

// RTCD֘A
#define EDGE_RTCD_NAME_INVALID					0x80000100	// RTCD̂sł
#define EDGE_RTCD_NAME_LENGTH_ERROR				0x80000101	// RTCD̂̕G[
#define EDGE_RTCD_RECORD_LENGTH_ERROR			0x80000102	// R[hG[
#define EDGE_RTCD_RECORD_NUM_ERROR				0x80000103	// R[hG[
#define EDGE_RTCD_WRITE_MODE_ERROR				0x80000105	// ݃[hG[
#define EDGE_RTCD_EXIST_ERROR					0x80000106	// ɓRTCD݂܂
#define EDGE_RTCD_NOT_EXIST_ERROR				0x80000107	// RTCD݂܂
#define EDGE_RTCD_NAME_EXIST_ERROR				0x80000108	// ɓOgĂ܂
#define EDGE_RTCD_ALLOCATE_ERROR				0x80000109	// mێs
#define EDGE_RTCD_FREE_ERROR					0x8000010A	// s
#define EDGE_RTCD_CREATE_MEM_HANDLE_ERROR		0x8000010B	// nhs
#define EDGE_RTCD_DELETE_MEM_HANDLE_ERROR		0x8000010C	// nh폜s
#define EDGE_RTCD_CATALOG_ERROR					0x8000010D	// J^Os
#define EDGE_RTCD_UNCATALOG_ERROR				0x8000010E	// AJ^Os
#define EDGE_RTCD_LOOKUP_ERROR					0x8000010F	// bNAbvs
#define EDGE_RTCD_MAPPING_ERROR					0x80000110	// }bsOs
#define EDGE_RTCD_UNMAPPING_ERROR				0x80000111	// A}bsOs
#define EDGE_RTCD_ACCESS_MODE_ERROR				0x80000112	// ANZX[hG[
#define EDGE_RTCD_ALREADY_OPEN_READ_ERROR		0x80000113	// ɓǍ݃ANZXŃI[vĂ܂
#define EDGE_RTCD_ALREADY_OPEN_WRITE_ERROR		0x80000114	// ɏ݃ANZXŃI[vĂ܂(VO[h)
#define EDGE_RTCD_MEMINFO_INVALID				0x80000115	// RTCD񂪕sł
#define EDGE_RTCD_HANDLE_INVALID				0x80000116	// nhsł
#define EDGE_RTCD_BUFFER_INVALID				0x80000117	// obt@sł
#define EDGE_RTCD_BUFFER_SIZE_INVALID			0x80000118	// obt@TCYsł
#define EDGE_RTCD_WRITE_SIZE_INVALID			0x80000119	// ݃TCYsł
#define EDGE_RTCD_RECORD_HEADER_INVALID			0x8000011A	// RTCDwb_[sł
#define EDGE_RTCD_INFO_INVALID					0x8000011B	// RTCD񂪕sł
#define EDGE_RTCD_NO_UPDATE						0x8000011C	// f[^XV܂
#define EDGE_RTCD_BUFFER_FULL_ERROR				0x8000011D	// obt@tG[

#define EDGE_RTCD_CREATE_SEMAPHORE1_ERROR		0x80000200	// Z}tHG[(rpZ}tH)
#define EDGE_RTCD_CREATE_SEMAPHORE2_ERROR		0x80000201	// Z}tHG[(ʒmpZ}tH)
#define EDGE_RTCD_DELETE_SEMAPHORE1_ERROR		0x80000202	// Z}tH폜G[(rpZ}tH)
#define EDGE_RTCD_DELETE_SEMAPHORE2_ERROR		0x80000203	// Z}tH폜G[(ʒmpZ}tH)
#define EDGE_RTCD_CATALOG_SEMAPHORE1_ERROR		0x80000204	// Z}tHJ^OG[(rpZ}tH)
#define EDGE_RTCD_CATALOG_SEMAPHORE2_ERROR		0x80000205	// Z}tHJ^OG[(ʒmpZ}tH)
#define EDGE_RTCD_SEMAPHORE_TIMEOUT				0x80000206	// Z}tH擾^CAEg
#define EDGE_RTCD_WAIT_SEMAPHORE_ERROR			0x80000207	// Z}tH擾G[
#define EDGE_RTCD_RELEASE_SEMAPHORE_ERROR		0x80000208	// Z}tHG[
#define EDGE_RTCD_OPEN_SEMAPHORE1_ERROR			0x80000209	// Z}tHI[vG[(rpZ}tH)
#define EDGE_RTCD_OPEN_SEMAPHORE2_ERROR			0x8000020A	// Z}tHI[vG[(ʒmpZ}tH)
#define EDGE_RTCD_NOT_EXIST_SEMAPHORE_ERROR		0x8000020B	// Z}tH݂܂
#define EDGE_RTCD_LOOKUP_SEMAPHORE_ERROR		0x8000020C	// Z}tHbNAbvG[
#define EDGE_RTCD_SEMAPHORE1_EXIST_ERROR		0x8000020D	// ɓZ}tH݂܂(rpZ}tH)
#define EDGE_RTCD_SEMAPHORE1_NAME_EXIST_ERROR	0x8000020E	// ɓOgĂ܂(rpZ}tH)
#define EDGE_RTCD_SEMAPHORE2_EXIST_ERROR		0x8000020F	// ɓZ}tH݂܂(ʒmpZ}tH)
#define EDGE_RTCD_SEMAPHORE2_NAME_EXIST_ERROR	0x80000210	// ɓOgĂ܂(ʒmpZ}tH)

#define EDGE_RTCD_CREATE_MEMFILE_ERROR			0x80000300	// }bvgt@CG[
#define EDGE_RTCD_CREATE_FILEMAPPING_ERROR		0x80000301	// t@C}bsOG[
#define EDGE_RTCD_OPEN_FILEMAPPING_ERROR		0x80000302	// t@C}bsOI[vG[
#define EDGE_RTCD_MAP_VIEW_ERROR				0x80000303	// r[}bvG[
#define EDGE_RTCD_UNMAP_VIEW_ERROR				0x80000304	// r[A}bvG[


//------------------------------------------------------------------------------
// APIp萔
//------------------------------------------------------------------------------
// RTCD݃[h
#define RTCD_WRITE_SINGLE	0x00000001	// ݃VO[h
#define RTCD_WRITE_MULTI	0x00000002	// ݃}`[h
// RTCDANZX[h
#define RTCD_READ			0x00000001	// Ǎ݃ANZX
#define RTCD_WRITE			0x00000002	// ݃ANZX
#define RTCD_READWRITE		0x00000003	// ǏANZX


//------------------------------------------------------------------------------
// \̒`
//------------------------------------------------------------------------------
#pragma pack(push,1)

// RTCDwb_[ (256oCg) +12
typedef union
{
	struct {
		DWORD record_num;				// R[h
		DWORD record_size;				// R[hTCY(oCg)
		DWORD read_pos;					// Ǎ݈ʒu
		DWORD write_pos;				// ݈ʒu
		DWORD write_mode;				// ݃[h 1:VO 2:}`
		DWORD read_open_count;			// Ǎ݃[hI[vJE^
		DWORD write_open_count;			// ݃[hI[vJE^
		DWORD lost_count;				// JE^
		OBJHANDLE mem_handle;			// RTCDnhl
		OBJHANDLE lock_sem_handle;		// rpZ}tHnhl
		OBJHANDLE notify_sem_handle;	// ʒmpZ}tHnhl
		char name[12];					// RTCD(ő10܂)
	};
    BYTE reserve[256];				// \
} EDGE_RTCD_HEADER;

// RTCD (28oCg) +12
typedef union
{
	struct {
		BYTE *pRtcd;					// RTCD|C^({)
		OBJHANDLE mem_handle;			// RTCDnh
		OBJHANDLE sem1_handle;			// rpZ}tHnh
		OBJHANDLE sem2_handle;			// ʒmpZ}tHnh
		char name[12];					// RTCD(ő10܂)
	};
	BYTE reserve[28];
} EDGE_RTCD_MEM_INFO, RTCDMEMINFO;

// RTCDnh (28oCg)
typedef union
{
	struct {
		DWORD  code;					// RTCDnhʃR[h
		EDGE_RTCD_HEADER *pRtcdHeader;	// RTCDwb_[̃|C^
		BYTE *pRtcdData;				// RTCDf[^̃|C^
		void *pMem_handle;				// RTCDnh
		void *pSem1_handle;				// rpZ}tHnh
		void *pSem2_handle;				// ʒmpZ}tHnh
		DWORD  access;					// ANZX[h
	};
	BYTE reserved[28];
} EDGE_RTCD_HANDLE, RTCDHANDLE;

// t@Cnh (264oCg)
typedef struct
{
    char  path[256];				// t@CpX
    void* pHandle;					// Xbhnh
    DWORD mode;						// ANZX[h
} EDGE_FILE_HANDLE, RTFHANDLE;

// RTCDR[hwb_[ (32oCg)
typedef struct
{
    unsigned long long time;		// ݓ (1970N11̌oߕb)
    WORD millisecond;				// ݓ ~b
    WORD microsecond;				// ݓ }CNb
	DWORD size;						// f[^TCY(bytes)
    WORD lost_count;				// JE^
	BYTE reserve[14];				// \
} EDGE_RECORD_HEADER;

// ^CX^v (12oCg)
typedef struct
{
    unsigned long long time;		// ݓ 1970N11̌oߕb
    WORD millisecond;				// ݓ ~b
    WORD microsecond;				// ݓ }CNb
} EDGE_TIME_STAMP;

// ^CX^v (12oCg)
typedef struct
{
	unsigned long long time;		// ݓ 1970N11̌oߕb
	unsigned long microsecond;		// ݓ }CNb
} EDGE_TIME_VAL;

#pragma pack(pop)


//------------------------------------------------------------------------------
// RT-edge API`
//------------------------------------------------------------------------------
// RTCD@\
egRTCD_API int edgeCreateRTCD(const char *pName, DWORD dwMode, DWORD dwLength, DWORD dwNum, RTCDMEMINFO *pRtcdInfo);
egRTCD_API int edgeDeleteRTCD(RTCDMEMINFO *pRtcdInfo);
egRTCD_API int edgeOpenRTCD(const char *pName, DWORD dwAccess, RTCDHANDLE *pHandle);
egRTCD_API int edgeCloseRTCD(RTCDHANDLE *pHandle);
egRTCD_API int edgeWriteRTCD(RTCDHANDLE *pHandle, void *pBuffer, DWORD dwSize);
egRTCD_API int edgeWriteRTCD4Mbox(RTCDHANDLE *pHandle, void *pBuffer1, DWORD dwSize1, void *pBuffer2, DWORD dwSize2);
egRTCD_API int edgeReadRTCD(RTCDHANDLE *pHandle, void *pBuffer, DWORD dwBufferSize, EDGE_RECORD_HEADER *pDataTime, DWORD dwTimeout);
egRTCD_API int edgeReadRTCD4Mbox(RTCDHANDLE *pHandle, void *pBuffer1, DWORD dwBufferSize1, void *pBuffer2, DWORD dwBufferSize2, EDGE_RECORD_HEADER *pDataTime, DWORD dwTimeout);
egRTCD_API int edgeGetRTCDInfo(RTCDHANDLE *pHandle, EDGE_RTCD_HEADER *pInfo);
egRTCD_API int edgeClearRTCDCounter(const char *pName, DWORD dwAccess);
egRTCD_API int edgeIsRTCDHandle(RTCDHANDLE *pHandle);

// bZ[WʐM@\
egRTCD_API int edgeCreateMailbox(const char *pName, DWORD dwLength, DWORD dwNum, RTCDMEMINFO *pRtcdInfo);
egRTCD_API int edgeDeleteMailbox(RTCDMEMINFO *pRtcdInfo);
egRTCD_API int edgeOpenMailbox(const char *pName, DWORD dwAccess, RTCDHANDLE *pHandle);
egRTCD_API int edgeCloseMailbox(RTCDHANDLE *pHandle);
egRTCD_API int edgeSendData(RTCDHANDLE *pHandle, void *pBuffer, DWORD dwSize);
egRTCD_API int edgeSendData4Mbox(RTCDHANDLE *pHandle, void *pBuffer1, DWORD dwSize1, void *pBuffer2, DWORD dwSize2);
egRTCD_API int edgeReceiveData(RTCDHANDLE *pHandle, void *pBuffer, DWORD dwBufferSize, DWORD dwTimeout);
egRTCD_API int edgeReceiveData4Mbox(RTCDHANDLE *pHandle, void *pBuffer1, DWORD dwBufferSize1, void *pBuffer2, DWORD dwBufferSize2, DWORD dwTimeout);
egRTCD_API int edgeHandleCheck(RTCDHANDLE *pHandle); // nh`FbN

// T[rX@\
egRTCD_API int edgeGetTimestamp(EDGE_TIME_STAMP *pTime);
egRTCD_API int edgeGetTimeVal(EDGE_TIME_VAL *pTime);

#ifdef __cplusplus
}
#endif
